/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdistmulti;

import optimization.Uncmin_f77;
import optimization.Uncmin_methods;
import umontreal.iro.lecuyer.probdistmulti.ContinuousDistributionMulti;
import umontreal.iro.lecuyer.util.Num;

public class DirichletDist
extends ContinuousDistributionMulti {
    protected double[] alpha;

    public DirichletDist(double[] dArray) {
        this.setParams(dArray);
    }

    public double density(double[] dArray) {
        return DirichletDist.density_(this.alpha, dArray);
    }

    public double[] getMean() {
        return DirichletDist.getMean_(this.alpha);
    }

    public double[][] getCovariance() {
        return DirichletDist.getCovariance_(this.alpha);
    }

    public double[][] getCorrelation() {
        return DirichletDist.getCorrelation_(this.alpha);
    }

    private static void verifParam(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] <= 0.0)) continue;
            throw new IllegalArgumentException("alpha[" + i + "] <= 0");
        }
    }

    private static double density_(double[] dArray, double[] dArray2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("alpha and x must have the same dimension");
        }
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
            d2 += Num.lnGamma(dArray[i]);
            d3 += (dArray[i] - 1.0) * Math.log(dArray2[i]);
        }
        return Math.exp(Num.lnGamma(d) - d2 + d3);
    }

    public static double density(double[] dArray, double[] dArray2) {
        DirichletDist.verifParam(dArray);
        return DirichletDist.density_(dArray, dArray2);
    }

    private static double[][] getCovariance_(double[] dArray) {
        int n;
        double[][] dArray2 = new double[dArray.length][dArray.length];
        double d = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d += dArray[n];
        }
        for (n = 0; n < dArray.length; ++n) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray2[n][i] = -(dArray[n] * dArray[i]) / (d * d * (d + 1.0));
            }
            dArray2[n][n] = dArray[n] / d * (1.0 - dArray[n] / d) / (d + 1.0);
        }
        return dArray2;
    }

    public static double[][] getCovariance(double[] dArray) {
        DirichletDist.verifParam(dArray);
        return DirichletDist.getCovariance_(dArray);
    }

    private static double[][] getCorrelation_(double[] dArray) {
        int n;
        double[][] dArray2 = new double[dArray.length][dArray.length];
        double d = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d += dArray[n];
        }
        for (n = 0; n < dArray.length; ++n) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray2[n][i] = -Math.sqrt(dArray[n] * dArray[i] / ((d - dArray[n]) * (d - dArray[i])));
            }
            dArray2[n][n] = 1.0;
        }
        return dArray2;
    }

    public static double[][] getCorrelation(double[] dArray) {
        DirichletDist.verifParam(dArray);
        return DirichletDist.getCorrelation_(dArray);
    }

    public static double[] getMaximumLikelihoodEstimate(double[][] dArray, int n, int n2) {
        int n3;
        int n4;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        for (n4 = 0; n4 < n2; ++n4) {
            dArray2[n4] = 0.0;
            dArray3[n4] = 0.0;
        }
        for (n4 = 0; n4 < n; ++n4) {
            for (n3 = 0; n3 < n2; ++n3) {
                int n5 = n3;
                dArray2[n5] = dArray2[n5] + Math.log(dArray[n4][n3]);
                int n6 = n3;
                dArray3[n6] = dArray3[n6] + dArray[n4][n3];
            }
        }
        n4 = 0;
        while (n4 < n2) {
            int n7 = n4;
            dArray2[n7] = dArray2[n7] / (double)n;
            int n8 = n4++;
            dArray3[n8] = dArray3[n8] / (double)n;
        }
        double d = 0.0;
        for (n3 = 0; n3 < n2; ++n3) {
            d = 0.0;
            for (n4 = 0; n4 < n; ++n4) {
                d += (dArray[n4][n3] - dArray3[n3]) * (dArray[n4][n3] - dArray3[n3]);
            }
            dArray4[n3] = d / (double)n;
        }
        double d2 = dArray3[0] * (1.0 - dArray3[0]) / dArray4[0] - 1.0;
        Optim optim = new Optim(dArray2, n);
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n2 + 1];
        double[] dArray7 = new double[n2 + 1];
        double[] dArray8 = new double[n2 + 1];
        double[] dArray9 = new double[n2 + 1];
        int[] nArray = new int[2];
        double[][] dArray10 = new double[n2 + 1][n2 + 1];
        double[] dArray11 = new double[n2 + 1];
        for (n4 = 1; n4 <= n2; ++n4) {
            dArray7[n4] = dArray3[n4 - 1] * d2;
        }
        Uncmin_f77.optif0_f77((int)n2, (double[])dArray7, (Uncmin_methods)optim, (double[])dArray6, (double[])dArray8, (double[])dArray9, (int[])nArray, (double[][])dArray10, (double[])dArray11);
        for (n4 = 0; n4 < n2; ++n4) {
            dArray5[n4] = dArray6[n4 + 1];
        }
        return dArray5;
    }

    private static double[] getMean_(double[] dArray) {
        int n;
        double d = 0.0;
        double[] dArray2 = new double[dArray.length];
        for (n = 0; n < dArray.length; ++n) {
            d += dArray[n];
        }
        for (n = 0; n < dArray.length; ++n) {
            dArray2[n] = dArray[n] / d;
        }
        return dArray2;
    }

    public static double[] getMean(double[] dArray) {
        DirichletDist.verifParam(dArray);
        return DirichletDist.getMean_(dArray);
    }

    public double[] getAlpha() {
        return this.alpha;
    }

    public double getAlpha(int n) {
        return this.alpha[n];
    }

    public void setParams(double[] dArray) {
        this.dimension = dArray.length;
        this.alpha = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            if (dArray[i] <= 0.0) {
                throw new IllegalArgumentException("alpha[" + i + "] <= 0");
            }
            this.alpha[i] = dArray[i];
        }
    }

    private static class Optim
    implements Uncmin_methods {
        double[] logP;
        int n;
        int k;

        public Optim(double[] dArray, int n) {
            this.n = n;
            this.k = dArray.length;
            this.logP = new double[this.k];
            System.arraycopy(dArray, 0, this.logP, 0, this.k);
        }

        public double f_to_minimize(double[] dArray) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i = 1; i < dArray.length; ++i) {
                if (dArray[i] <= 0.0) {
                    return 1.0E200;
                }
                d += dArray[i];
                d2 += Num.lnGamma(dArray[i]);
                d3 += (dArray[i] - 1.0) * this.logP[i - 1];
            }
            return (double)(-this.n) * (Num.lnGamma(d) - d2 + d3);
        }

        public void gradient(double[] dArray, double[] dArray2) {
        }

        public void hessian(double[] dArray, double[][] dArray2) {
        }
    }
}

