/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.plots.ElementModel;
import org.rosuda.deducer.plots.ElementView;
import org.rosuda.deducer.plots.PlottingElement;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;

public class PlottingElementDialog
extends JDialog
implements ActionListener {
    private JPanel panel;
    private JPanel okayCancel;
    private HelpButton help;
    private ElementView view;
    private ElementModel initialModel;
    private PlottingElement element;
    private int exitType = -1;

    public PlottingElementDialog(JFrame jFrame, PlottingElement plottingElement) {
        super(jFrame);
        this.initGUI();
        this.setElement(plottingElement);
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.getContentPane().setLayout((LayoutManager)anchorLayout);
            this.help = new HelpButton("");
            this.getContentPane().add((Component)this.help, new AnchorConstraint(923, 92, 12, 12, 0, 0, 2, 2));
            this.help.setPreferredSize(new Dimension(36, 36));
            this.okayCancel = new OkayCancelPanel(false, false, this);
            this.getContentPane().add((Component)this.okayCancel, new AnchorConstraint(923, 21, 0, 521, 0, 2, 2, 0));
            this.okayCancel.setPreferredSize(new Dimension(195, 38));
            this.panel = new JPanel();
            BorderLayout borderLayout = new BorderLayout();
            this.panel.setLayout(borderLayout);
            this.getContentPane().add((Component)this.panel, new AnchorConstraint(1, 994, 44, 1, 1, 1, 2, 1));
            this.panel.setPreferredSize(new Dimension(447, 449));
            this.setSize(450, 515);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setElement(PlottingElement plottingElement) {
        this.setView((ElementView)plottingElement.getPanel());
        this.initialModel = (ElementModel)plottingElement.getModel().clone();
        this.help.setUrl(plottingElement.getUrl());
        this.help.setToolTipText("Open online help from: " + plottingElement.getUrl());
        this.element = plottingElement;
    }

    public void setView(ElementView elementView) {
        this.view = elementView;
        this.panel.removeAll();
        this.panel.add(this.view);
    }

    public void setToInitialModel() {
        this.element.setModel(this.initialModel);
    }

    public int getExitType() {
        return this.exitType;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "OK") {
            this.view.updateModel();
            String string2 = this.view.getModel().checkValid();
            if (string2 != null) {
                JOptionPane.showMessageDialog(this, string2);
            } else {
                this.exitType = 1;
                this.dispose();
            }
        } else if (string == "Cancel") {
            this.exitType = 0;
            this.setToInitialModel();
            this.dispose();
        }
    }
}

