/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glacier.model.transform.PartListElementMarshaller;
import java.io.Serializable;

public class PartListElement
implements Serializable,
Cloneable,
StructuredPojo {
    private String rangeInBytes;
    private String sHA256TreeHash;

    public void setRangeInBytes(String rangeInBytes) {
        this.rangeInBytes = rangeInBytes;
    }

    public String getRangeInBytes() {
        return this.rangeInBytes;
    }

    public PartListElement withRangeInBytes(String rangeInBytes) {
        this.setRangeInBytes(rangeInBytes);
        return this;
    }

    public void setSHA256TreeHash(String sHA256TreeHash) {
        this.sHA256TreeHash = sHA256TreeHash;
    }

    public String getSHA256TreeHash() {
        return this.sHA256TreeHash;
    }

    public PartListElement withSHA256TreeHash(String sHA256TreeHash) {
        this.setSHA256TreeHash(sHA256TreeHash);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRangeInBytes() != null) {
            sb.append("RangeInBytes: ").append(this.getRangeInBytes()).append(",");
        }
        if (this.getSHA256TreeHash() != null) {
            sb.append("SHA256TreeHash: ").append(this.getSHA256TreeHash());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartListElement)) {
            return false;
        }
        PartListElement other = (PartListElement)obj;
        if (other.getRangeInBytes() == null ^ this.getRangeInBytes() == null) {
            return false;
        }
        if (other.getRangeInBytes() != null && !other.getRangeInBytes().equals(this.getRangeInBytes())) {
            return false;
        }
        if (other.getSHA256TreeHash() == null ^ this.getSHA256TreeHash() == null) {
            return false;
        }
        return other.getSHA256TreeHash() == null || other.getSHA256TreeHash().equals(this.getSHA256TreeHash());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRangeInBytes() == null ? 0 : this.getRangeInBytes().hashCode());
        hashCode = 31 * hashCode + (this.getSHA256TreeHash() == null ? 0 : this.getSHA256TreeHash().hashCode());
        return hashCode;
    }

    public PartListElement clone() {
        try {
            return (PartListElement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PartListElementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

