/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model.transform;

import com.simba.athena.amazonaws.services.glue.model.Crawler;
import com.simba.athena.amazonaws.services.glue.model.transform.CrawlerTargetsJsonUnmarshaller;
import com.simba.athena.amazonaws.services.glue.model.transform.LastCrawlInfoJsonUnmarshaller;
import com.simba.athena.amazonaws.services.glue.model.transform.ScheduleJsonUnmarshaller;
import com.simba.athena.amazonaws.services.glue.model.transform.SchemaChangePolicyJsonUnmarshaller;
import com.simba.athena.amazonaws.transform.JsonUnmarshallerContext;
import com.simba.athena.amazonaws.transform.ListUnmarshaller;
import com.simba.athena.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.simba.athena.amazonaws.transform.Unmarshaller;
import com.simba.athena.shaded.fasterxml.jackson.core.JsonToken;

public class CrawlerJsonUnmarshaller
implements Unmarshaller<Crawler, JsonUnmarshallerContext> {
    private static CrawlerJsonUnmarshaller instance;

    @Override
    public Crawler unmarshall(JsonUnmarshallerContext context) throws Exception {
        Crawler crawler = new Crawler();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    crawler.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Role", targetDepth)) {
                    context.nextToken();
                    crawler.setRole(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Targets", targetDepth)) {
                    context.nextToken();
                    crawler.setTargets(CrawlerTargetsJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DatabaseName", targetDepth)) {
                    context.nextToken();
                    crawler.setDatabaseName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    crawler.setDescription(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Classifiers", targetDepth)) {
                    context.nextToken();
                    crawler.setClassifiers(new ListUnmarshaller<String>(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("SchemaChangePolicy", targetDepth)) {
                    context.nextToken();
                    crawler.setSchemaChangePolicy(SchemaChangePolicyJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("State", targetDepth)) {
                    context.nextToken();
                    crawler.setState(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TablePrefix", targetDepth)) {
                    context.nextToken();
                    crawler.setTablePrefix(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Schedule", targetDepth)) {
                    context.nextToken();
                    crawler.setSchedule(ScheduleJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CrawlElapsedTime", targetDepth)) {
                    context.nextToken();
                    crawler.setCrawlElapsedTime(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    crawler.setCreationTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("LastUpdated", targetDepth)) {
                    context.nextToken();
                    crawler.setLastUpdated(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("LastCrawl", targetDepth)) {
                    context.nextToken();
                    crawler.setLastCrawl(LastCrawlInfoJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Version", targetDepth)) {
                    context.nextToken();
                    crawler.setVersion(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("Configuration", targetDepth)) {
                    context.nextToken();
                    crawler.setConfiguration(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CrawlerSecurityConfiguration", targetDepth)) {
                    context.nextToken();
                    crawler.setCrawlerSecurityConfiguration(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return crawler;
    }

    public static CrawlerJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CrawlerJsonUnmarshaller();
        }
        return instance;
    }
}

