/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.services.glue.model.CodeGenNode;
import java.util.List;

@SdkInternalApi
public class CodeGenNodeMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<String> NODETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeType").build();
    private static final MarshallingInfo<List> ARGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Args").build();
    private static final MarshallingInfo<Integer> LINENUMBER_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LineNumber").build();
    private static final CodeGenNodeMarshaller instance = new CodeGenNodeMarshaller();

    public static CodeGenNodeMarshaller getInstance() {
        return instance;
    }

    public void marshall(CodeGenNode codeGenNode, ProtocolMarshaller protocolMarshaller) {
        if (codeGenNode == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(codeGenNode.getId(), ID_BINDING);
            protocolMarshaller.marshall(codeGenNode.getNodeType(), NODETYPE_BINDING);
            protocolMarshaller.marshall(codeGenNode.getArgs(), ARGS_BINDING);
            protocolMarshaller.marshall(codeGenNode.getLineNumber(), LINENUMBER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

