/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.meta;

import com.github.javacliparser.FloatOption;
import com.yahoo.labs.samoa.instances.Instance;
import moa.classifiers.MultiClassClassifier;
import moa.classifiers.meta.HeterogeneousEnsembleAbstract;

public class HeterogeneousEnsembleBlastFadingFactors
extends HeterogeneousEnsembleAbstract
implements MultiClassClassifier {
    private static final long serialVersionUID = 1L;
    private static final int MAX_TOLLERATED_TRAINING_ERRROS = 100;
    private int trainingErrors;
    public FloatOption alphaOption = new FloatOption("alpha", 'a', "The fading factor.", 0.999, 0.0, 1.0);

    @Override
    public void resetLearningImpl() {
        int i;
        this.historyTotal = new double[this.ensemble.length];
        for (i = 0; i < this.ensemble.length; ++i) {
            this.historyTotal[i] = 1.0;
        }
        this.instancesSeen = 0;
        this.trainingErrors = 0;
        for (i = 0; i < this.ensemble.length; ++i) {
            this.ensemble[i].resetLearning();
        }
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        for (int i = 0; i < this.ensemble.length; ++i) {
            double[] votes = this.ensemble[i].getVotesForInstance(inst);
            boolean correct = (double)HeterogeneousEnsembleBlastFadingFactors.maxIndex(votes) * 1.0 == inst.classValue();
            this.historyTotal[i] = this.historyTotal[i] * this.alphaOption.getValue();
            if (correct) {
                int n = i;
                this.historyTotal[n] = this.historyTotal[n] + (1.0 - this.alphaOption.getValue());
            }
            try {
                this.ensemble[i].trainOnInstance(inst);
                continue;
            }
            catch (RuntimeException e) {
                ++this.trainingErrors;
                if (this.trainingErrors <= 100) continue;
                throw new RuntimeException("Too much training errors! Latest: " + e.getMessage());
            }
        }
        this.instancesSeen = this.instancesSeen + 1;
        if (this.instancesSeen % this.gracePerionOption.getValue() == 0) {
            this.topK = HeterogeneousEnsembleBlastFadingFactors.topK(this.historyTotal, this.activeClassifiersOption.getValue());
        }
    }
}

