/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.grid;

import fr.ird.osmose.Cell;
import fr.ird.osmose.Configuration;
import fr.ird.osmose.Osmose;
import fr.ird.osmose.grid.IGrid;
import fr.ird.osmose.util.io.IOTools;
import fr.ird.osmose.util.logging.OLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;

public abstract class AbstractGrid
extends OLogger
implements IGrid {
    private Cell[][] matrix;
    private int ny;
    private int nx;
    private float latMax;
    private float latMin;
    private float longMax;
    private float longMin;
    private float dLat;
    private float dLong;

    abstract Cell[][] makeGrid();

    abstract void readParameters();

    @Override
    public void init() {
        this.readParameters();
        this.matrix = this.makeGrid();
        this.getDimGeogArea();
    }

    @Override
    public Cell getCell(int i, int j) {
        return this.matrix[j][i];
    }

    @Override
    public Cell getCell(int index) {
        int j = index / this.nx;
        int i = index - j * this.nx;
        return this.matrix[j][i];
    }

    @Override
    public List<Cell> getCells() {
        ArrayList<Cell> cells = new ArrayList<Cell>(this.ny * this.nx);
        int j = this.ny;
        while (j-- > 0) {
            int i = this.nx;
            while (i-- > 0) {
                cells.add(this.matrix[j][i]);
            }
        }
        return cells;
    }

    @Override
    public ArrayList<Cell> getNeighbourCells(Cell cell, int range) {
        int im1 = Math.max(cell.get_igrid() - range, 0);
        int ip1 = Math.min(cell.get_igrid() + range, this.get_nx() - 1);
        int jm1 = Math.max(cell.get_jgrid() - range, 0);
        int jp1 = Math.min(cell.get_jgrid() + range, this.get_ny() - 1);
        ArrayList<Cell> neighbours = new ArrayList<Cell>();
        for (int i = im1; i <= ip1; ++i) {
            for (int j = jm1; j <= jp1; ++j) {
                neighbours.add(this.matrix[j][i]);
            }
        }
        return neighbours;
    }

    @Override
    public int getNOceanCell() {
        int nbCells = 0;
        for (int j = 0; j < this.ny; ++j) {
            for (int i = 0; i < this.nx; ++i) {
                if (this.matrix[j][i].isLand()) continue;
                ++nbCells;
            }
        }
        return nbCells;
    }

    private void getDimGeogArea() {
        this.ny = this.matrix.length;
        this.nx = this.matrix[0].length;
        this.longMin = Float.MAX_VALUE;
        this.longMax = -3.4028235E38f;
        this.latMin = Float.MAX_VALUE;
        this.latMax = -3.4028235E38f;
        int j = this.ny;
        while (j-- > 0) {
            int i = this.nx;
            while (i-- > 0) {
                if (this.matrix[j][i].getLon() >= this.longMax) {
                    this.longMax = this.matrix[j][i].getLon();
                }
                if (this.matrix[j][i].getLon() <= this.longMin) {
                    this.longMin = this.matrix[j][i].getLon();
                }
                if (this.matrix[j][i].getLat() >= this.latMax) {
                    this.latMax = this.matrix[j][i].getLat();
                }
                if (!(this.matrix[j][i].getLat() <= this.latMin)) continue;
                this.latMin = this.matrix[j][i].getLat();
            }
        }
        if (this.longMin > this.longMax) {
            float float_tmp = this.longMin;
            this.longMin = this.longMax;
            this.longMax = float_tmp;
        }
        if (this.latMin > this.latMax) {
            float float_tmp = this.latMin;
            this.latMin = this.latMax;
            this.latMax = float_tmp;
        }
        this.dLat = (this.latMax - this.latMin) / (float)this.ny;
        this.dLong = (this.longMax - this.longMin) / (float)this.nx;
    }

    @Override
    public int get_ny() {
        return this.ny;
    }

    @Override
    public int get_nx() {
        return this.nx;
    }

    @Override
    public float getLatMax() {
        return this.latMax;
    }

    @Override
    public float getLatMin() {
        return this.latMin;
    }

    @Override
    public float getLongMax() {
        return this.longMax;
    }

    @Override
    public float getLongMin() {
        return this.longMin;
    }

    @Override
    public float getdLat() {
        return this.dLat;
    }

    @Override
    public float getdLong() {
        return this.dLong;
    }

    @Override
    public void toNetCDF(String filename) {
        NetcdfFileWriteable nc = null;
        try {
            nc = NetcdfFileWriteable.createNew("");
            IOTools.makeDirectories(filename);
            nc.setLocation(filename);
        }
        catch (IOException ex) {
            this.error("Failed to created NetCDF grid file " + filename, ex);
        }
        Dimension nxDim = nc.addDimension("nx", this.nx);
        Dimension nyDim = nc.addDimension("ny", this.ny);
        nc.addVariable("latitude", DataType.DOUBLE, new Dimension[]{nyDim, nxDim});
        nc.addVariableAttribute("latitude", "units", "north degree");
        nc.addVariableAttribute("latitude", "description", "latitude of the center of the cell");
        nc.addVariable("longitude", DataType.DOUBLE, new Dimension[]{nyDim, nxDim});
        nc.addVariableAttribute("longitude", "units", "south degree");
        nc.addVariableAttribute("longitude", "description", "longitude of the center of the cell");
        nc.addVariable("mask", DataType.DOUBLE, new Dimension[]{nyDim, nxDim});
        nc.addVariableAttribute("mask", "units", "boolean");
        nc.addVariableAttribute("mask", "description", "mask of the grid, one means ocean and zero means continent");
        try {
            nc.create();
            ArrayDouble.D2 arrLon = new ArrayDouble.D2(this.get_ny(), this.get_nx());
            ArrayDouble.D2 arrLat = new ArrayDouble.D2(this.get_ny(), this.get_nx());
            ArrayDouble.D2 arrMask = new ArrayDouble.D2(this.get_ny(), this.get_nx());
            for (Cell cell : this.getCells()) {
                arrLon.set(cell.get_jgrid(), cell.get_igrid(), cell.getLon());
                arrLat.set(cell.get_jgrid(), cell.get_igrid(), cell.getLat());
                arrMask.set(cell.get_jgrid(), cell.get_igrid(), cell.isLand() ? 0.0 : 1.0);
            }
            nc.write("longitude", arrLon);
            nc.write("latitude", arrLat);
            nc.write("mask", arrMask);
        }
        catch (IOException ex) {
            this.error("Failed to write the NetCDF grid file", ex);
        }
        catch (InvalidRangeException ex) {
            this.error("Failed to write the NetCDF grid file", ex);
        }
        try {
            nc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    Configuration getConfiguration() {
        return Osmose.getInstance().getConfiguration();
    }
}

