/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.FatigueLifeDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class FatigueLifeGen
extends RandomVariateGen {
    protected double mu;
    protected double beta;
    protected double gamma;

    public FatigueLifeGen(RandomStream s, double mu, double beta, double gamma) {
        super(s, new FatigueLifeDist(mu, beta, gamma));
        this.setParams(mu, beta, gamma);
    }

    public FatigueLifeGen(RandomStream s, FatigueLifeDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getMu(), dist.getBeta(), dist.getGamma());
        }
    }

    public static double nextDouble(RandomStream s, double mu, double beta, double gamma) {
        return FatigueLifeDist.inverseF(mu, beta, gamma, s.nextDouble());
    }

    public double getBeta() {
        return this.beta;
    }

    public double getGamma() {
        return this.gamma;
    }

    public double getMu() {
        return this.mu;
    }

    protected void setParams(double mu, double beta, double gamma) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (gamma <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        this.mu = mu;
        this.beta = beta;
        this.gamma = gamma;
    }
}

