/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.csv;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

public class CSVWriter {
    private String fileName;
    private File file;
    private BufferedWriter writer;
    private ArrayList<String> headers;
    private ArrayList<String> values;

    public CSVWriter(String string) {
        this.fileName = string;
        this.headers = new ArrayList();
        this.values = new ArrayList();
    }

    public void close() {
        try {
            if (this.writer != null) {
                this.writer.close();
                this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.fileName), "UTF-8"));
                this.writer.write(65279);
                for (int i = 0; i < this.headers.size(); ++i) {
                    this.writer.write(this.headers.get(i) + ",");
                }
                this.writer.write("\n");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8"));
                while (bufferedReader.ready()) {
                    this.writer.write(bufferedReader.readLine() + "\n");
                }
                bufferedReader.close();
                this.writer.close();
                this.file.delete();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void clear() {
        for (int i = 0; i < this.values.size(); ++i) {
            this.values.set(i, new String(""));
        }
    }

    public void set(String string, Object object) {
        if (string == null) {
            string = "null";
        }
        if (object == null) {
            object = "null";
        }
        for (int i = 0; i < this.headers.size(); ++i) {
            if (this.headers.get(i).compareTo(string) != 0) continue;
            this.values.set(i, object.toString());
            return;
        }
        this.headers.add(string.toString());
        this.values.add(object.toString());
    }

    public void writeln() {
        try {
            if (this.writer == null) {
                this.file = new File(this.fileName + ".tmp");
                this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "UTF-8"));
            }
            for (int i = 0; i < this.values.size(); ++i) {
                this.writer.write(this.values.get(i) + ",");
            }
            this.writer.write("\n");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

