/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.CRC;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;

public class FileEncoder
implements MesgListener,
MesgDefinitionListener {
    private File file;
    private FileOutputStream out;
    private MesgDefinition[] lastMesgDefinition = new MesgDefinition[16];

    public FileEncoder() {
    }

    public FileEncoder(File file) {
        this.open(file);
    }

    public void open(File file) {
        file.delete();
        this.file = file;
        this.writeFileHeader();
        try {
            this.out = new FileOutputStream(this.file, true);
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
    }

    private void writeFileHeader() {
        if (this.file == null) {
            throw new FitRuntimeException("File not open.");
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "rw");
            long l = this.file.length() - 14L;
            int n = 0;
            int n2 = 0;
            if (l < 0L) {
                l = 0L;
            }
            for (int i = 0; i < 12; ++i) {
                switch (i) {
                    case 0: {
                        n = 14;
                        break;
                    }
                    case 1: {
                        n = 16;
                        break;
                    }
                    case 2: {
                        n = 74;
                        break;
                    }
                    case 3: {
                        n = 6;
                        break;
                    }
                    case 4: {
                        n = (int)(l & 0xFFL);
                        break;
                    }
                    case 5: {
                        n = (int)(l >> 8 & 0xFFL);
                        break;
                    }
                    case 6: {
                        n = (int)(l >> 16 & 0xFFL);
                        break;
                    }
                    case 7: {
                        n = (int)(l >> 24 & 0xFFL);
                        break;
                    }
                    case 8: {
                        n = 46;
                        break;
                    }
                    case 9: {
                        n = 70;
                        break;
                    }
                    case 10: {
                        n = 73;
                        break;
                    }
                    case 11: {
                        n = 84;
                        break;
                    }
                }
                randomAccessFile.write(n);
                n2 = CRC.get16(n2, (byte)n);
            }
            randomAccessFile.write(n2 & 0xFF);
            randomAccessFile.write(n2 >> 8 & 0xFF);
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
    }

    @Override
    public void onMesg(Mesg mesg) {
        this.write(mesg);
    }

    @Override
    public void onMesgDefinition(MesgDefinition mesgDefinition) {
        this.write(mesgDefinition);
    }

    public void write(MesgDefinition mesgDefinition) {
        if (this.file == null) {
            throw new FitRuntimeException("File not open.");
        }
        mesgDefinition.write(this.out);
        this.lastMesgDefinition[mesgDefinition.localNum] = mesgDefinition;
    }

    public void write(Mesg mesg) {
        if (this.file == null) {
            throw new FitRuntimeException("File not open.");
        }
        if (this.lastMesgDefinition[mesg.localNum] == null || !this.lastMesgDefinition[mesg.localNum].supports(mesg)) {
            this.write(new MesgDefinition(mesg));
        }
        mesg.write(this.out, this.lastMesgDefinition[mesg.localNum]);
    }

    public void write(List<Mesg> list) {
        for (Mesg mesg : list) {
            this.write(mesg);
        }
    }

    public void close() {
        if (this.file == null) {
            throw new FitRuntimeException("File not open.");
        }
        try {
            this.out.close();
            this.writeFileHeader();
            FileInputStream fileInputStream = new FileInputStream(this.file);
            int n = 0;
            long l = this.file.length();
            int n2 = 0;
            while ((long)n2 < l) {
                n = CRC.get16(n, (byte)fileInputStream.read());
                ++n2;
            }
            fileInputStream.close();
            this.out = new FileOutputStream(this.file, true);
            this.out.write(n & 0xFF);
            this.out.write(n >> 8 & 0xFF);
            this.out.close();
            this.file = null;
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
    }
}

