/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.spatial.plots.components;

import edu.cens.spatial.plots.components.AbstractComponentPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OptionsComponentPanel
extends AbstractComponentPanel {
    private final JTextField _lon = new JTextField(8);
    private final JTextField _lat = new JTextField(8);
    private final JComboBox _zoom = new JComboBox();

    private static String ds(double d) {
        return Double.isNaN(d) ? "" : "" + d;
    }

    public OptionsComponentPanel(double[][] dArray) {
        super(Collections.<String, String>emptyMap());
        int n;
        for (n = -10; n < 5; ++n) {
            this._zoom.addItem(n);
        }
        this._lon.setText(OptionsComponentPanel.ds((dArray[0][1] + dArray[0][0]) * 0.5));
        this._lat.setText(OptionsComponentPanel.ds((dArray[1][1] + dArray[1][0]) * 0.5));
        n = (int)Math.round(Math.log(Math.abs(0.5 * (dArray[0][1] - dArray[0][0]))));
        this._zoom.setSelectedItem(n);
        this._lat.setBorder(BorderFactory.createTitledBorder("Lat:"));
        this._lon.setBorder(BorderFactory.createTitledBorder("Lon:"));
        this._zoom.setBorder(BorderFactory.createTitledBorder("Zoom:"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this._lon, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this._lat, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JPanel jPanel = new JPanel();
        jPanel.add(this._zoom);
        this.add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.addOkPanel(gridBagConstraints, 1);
    }

    public String[][] getBox() {
        double[][] dArray = new double[2][2];
        try {
            double d = Double.parseDouble(this._lat.getText());
            double d2 = Double.parseDouble(this._lon.getText());
            int n = this._zoom.getSelectedItem().hashCode();
            dArray[0][0] = d2 - Math.exp(n);
            dArray[0][1] = d2 + Math.exp(n);
            dArray[1][0] = d - Math.exp(n);
            dArray[1][1] = d + Math.exp(n);
            this._lat.setText(OptionsComponentPanel.ds((dArray[1][1] + dArray[1][0]) * 0.5));
            this._zoom.setSelectedItem((int)Math.log(dArray[0][1] - dArray[0][0]));
            return new String[][]{{OptionsComponentPanel.ds(dArray[0][0]), OptionsComponentPanel.ds(dArray[0][1])}, {OptionsComponentPanel.ds(dArray[1][0]), OptionsComponentPanel.ds(dArray[1][1])}};
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    boolean doOK() {
        String string = this._lat.getText();
        String string2 = this._lon.getText();
        try {
            if (string != null && string.length() > 0) {
                Double.parseDouble(string);
            }
            if (string2 != null && string2.length() > 0) {
                Double.parseDouble(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }
}

