/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.EC2SecurityGroup;
import com.amazonaws.services.redshift.model.IPRange;
import com.amazonaws.services.redshift.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ClusterSecurityGroup
implements Serializable,
Cloneable {
    private String clusterSecurityGroupName;
    private String description;
    private SdkInternalList<EC2SecurityGroup> eC2SecurityGroups;
    private SdkInternalList<IPRange> iPRanges;
    private SdkInternalList<Tag> tags;

    public void setClusterSecurityGroupName(String clusterSecurityGroupName) {
        this.clusterSecurityGroupName = clusterSecurityGroupName;
    }

    public String getClusterSecurityGroupName() {
        return this.clusterSecurityGroupName;
    }

    public ClusterSecurityGroup withClusterSecurityGroupName(String clusterSecurityGroupName) {
        this.setClusterSecurityGroupName(clusterSecurityGroupName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ClusterSecurityGroup withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<EC2SecurityGroup> getEC2SecurityGroups() {
        if (this.eC2SecurityGroups == null) {
            this.eC2SecurityGroups = new SdkInternalList();
        }
        return this.eC2SecurityGroups;
    }

    public void setEC2SecurityGroups(Collection<EC2SecurityGroup> eC2SecurityGroups) {
        if (eC2SecurityGroups == null) {
            this.eC2SecurityGroups = null;
            return;
        }
        this.eC2SecurityGroups = new SdkInternalList(eC2SecurityGroups);
    }

    public ClusterSecurityGroup withEC2SecurityGroups(EC2SecurityGroup ... eC2SecurityGroups) {
        if (this.eC2SecurityGroups == null) {
            this.setEC2SecurityGroups((Collection<EC2SecurityGroup>)new SdkInternalList(eC2SecurityGroups.length));
        }
        for (EC2SecurityGroup ele : eC2SecurityGroups) {
            this.eC2SecurityGroups.add((Object)ele);
        }
        return this;
    }

    public ClusterSecurityGroup withEC2SecurityGroups(Collection<EC2SecurityGroup> eC2SecurityGroups) {
        this.setEC2SecurityGroups(eC2SecurityGroups);
        return this;
    }

    public List<IPRange> getIPRanges() {
        if (this.iPRanges == null) {
            this.iPRanges = new SdkInternalList();
        }
        return this.iPRanges;
    }

    public void setIPRanges(Collection<IPRange> iPRanges) {
        if (iPRanges == null) {
            this.iPRanges = null;
            return;
        }
        this.iPRanges = new SdkInternalList(iPRanges);
    }

    public ClusterSecurityGroup withIPRanges(IPRange ... iPRanges) {
        if (this.iPRanges == null) {
            this.setIPRanges((Collection<IPRange>)new SdkInternalList(iPRanges.length));
        }
        for (IPRange ele : iPRanges) {
            this.iPRanges.add((Object)ele);
        }
        return this;
    }

    public ClusterSecurityGroup withIPRanges(Collection<IPRange> iPRanges) {
        this.setIPRanges(iPRanges);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public ClusterSecurityGroup withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public ClusterSecurityGroup withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterSecurityGroupName() != null) {
            sb.append("ClusterSecurityGroupName: ").append(this.getClusterSecurityGroupName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getEC2SecurityGroups() != null) {
            sb.append("EC2SecurityGroups: ").append(this.getEC2SecurityGroups()).append(",");
        }
        if (this.getIPRanges() != null) {
            sb.append("IPRanges: ").append(this.getIPRanges()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSecurityGroup)) {
            return false;
        }
        ClusterSecurityGroup other = (ClusterSecurityGroup)obj;
        if (other.getClusterSecurityGroupName() == null ^ this.getClusterSecurityGroupName() == null) {
            return false;
        }
        if (other.getClusterSecurityGroupName() != null && !other.getClusterSecurityGroupName().equals(this.getClusterSecurityGroupName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getEC2SecurityGroups() == null ^ this.getEC2SecurityGroups() == null) {
            return false;
        }
        if (other.getEC2SecurityGroups() != null && !other.getEC2SecurityGroups().equals(this.getEC2SecurityGroups())) {
            return false;
        }
        if (other.getIPRanges() == null ^ this.getIPRanges() == null) {
            return false;
        }
        if (other.getIPRanges() != null && !other.getIPRanges().equals(this.getIPRanges())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterSecurityGroupName() == null ? 0 : this.getClusterSecurityGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEC2SecurityGroups() == null ? 0 : this.getEC2SecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getIPRanges() == null ? 0 : this.getIPRanges().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public ClusterSecurityGroup clone() {
        try {
            return (ClusterSecurityGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

