/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.elasticmapreduce.model.VolumeSpecification;

@SdkInternalApi
public class VolumeSpecificationMarshaller {
    private static final MarshallingInfo<String> VOLUMETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeType").build();
    private static final MarshallingInfo<Integer> IOPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Iops").build();
    private static final MarshallingInfo<Integer> SIZEINGB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeInGB").build();
    private static final VolumeSpecificationMarshaller instance = new VolumeSpecificationMarshaller();

    public static VolumeSpecificationMarshaller getInstance() {
        return instance;
    }

    public void marshall(VolumeSpecification volumeSpecification, ProtocolMarshaller protocolMarshaller) {
        if (volumeSpecification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)volumeSpecification.getVolumeType(), VOLUMETYPE_BINDING);
            protocolMarshaller.marshall((Object)volumeSpecification.getIops(), IOPS_BINDING);
            protocolMarshaller.marshall((Object)volumeSpecification.getSizeInGB(), SIZEINGB_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

