/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dax.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dax.model.ChangeType;
import com.amazonaws.services.dax.model.IsModifiable;
import com.amazonaws.services.dax.model.NodeTypeSpecificValue;
import com.amazonaws.services.dax.model.ParameterType;
import com.amazonaws.services.dax.model.transform.ParameterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Parameter
implements Serializable,
Cloneable,
StructuredPojo {
    private String parameterName;
    private String parameterType;
    private String parameterValue;
    private List<NodeTypeSpecificValue> nodeTypeSpecificValues;
    private String description;
    private String source;
    private String dataType;
    private String allowedValues;
    private String isModifiable;
    private String changeType;

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public Parameter withParameterName(String parameterName) {
        this.setParameterName(parameterName);
        return this;
    }

    public void setParameterType(String parameterType) {
        this.parameterType = parameterType;
    }

    public String getParameterType() {
        return this.parameterType;
    }

    public Parameter withParameterType(String parameterType) {
        this.setParameterType(parameterType);
        return this;
    }

    public void setParameterType(ParameterType parameterType) {
        this.withParameterType(parameterType);
    }

    public Parameter withParameterType(ParameterType parameterType) {
        this.parameterType = parameterType.toString();
        return this;
    }

    public void setParameterValue(String parameterValue) {
        this.parameterValue = parameterValue;
    }

    public String getParameterValue() {
        return this.parameterValue;
    }

    public Parameter withParameterValue(String parameterValue) {
        this.setParameterValue(parameterValue);
        return this;
    }

    public List<NodeTypeSpecificValue> getNodeTypeSpecificValues() {
        return this.nodeTypeSpecificValues;
    }

    public void setNodeTypeSpecificValues(Collection<NodeTypeSpecificValue> nodeTypeSpecificValues) {
        if (nodeTypeSpecificValues == null) {
            this.nodeTypeSpecificValues = null;
            return;
        }
        this.nodeTypeSpecificValues = new ArrayList<NodeTypeSpecificValue>(nodeTypeSpecificValues);
    }

    public Parameter withNodeTypeSpecificValues(NodeTypeSpecificValue ... nodeTypeSpecificValues) {
        if (this.nodeTypeSpecificValues == null) {
            this.setNodeTypeSpecificValues(new ArrayList<NodeTypeSpecificValue>(nodeTypeSpecificValues.length));
        }
        for (NodeTypeSpecificValue ele : nodeTypeSpecificValues) {
            this.nodeTypeSpecificValues.add(ele);
        }
        return this;
    }

    public Parameter withNodeTypeSpecificValues(Collection<NodeTypeSpecificValue> nodeTypeSpecificValues) {
        this.setNodeTypeSpecificValues(nodeTypeSpecificValues);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Parameter withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public Parameter withSource(String source) {
        this.setSource(source);
        return this;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public Parameter withDataType(String dataType) {
        this.setDataType(dataType);
        return this;
    }

    public void setAllowedValues(String allowedValues) {
        this.allowedValues = allowedValues;
    }

    public String getAllowedValues() {
        return this.allowedValues;
    }

    public Parameter withAllowedValues(String allowedValues) {
        this.setAllowedValues(allowedValues);
        return this;
    }

    public void setIsModifiable(String isModifiable) {
        this.isModifiable = isModifiable;
    }

    public String getIsModifiable() {
        return this.isModifiable;
    }

    public Parameter withIsModifiable(String isModifiable) {
        this.setIsModifiable(isModifiable);
        return this;
    }

    public void setIsModifiable(IsModifiable isModifiable) {
        this.withIsModifiable(isModifiable);
    }

    public Parameter withIsModifiable(IsModifiable isModifiable) {
        this.isModifiable = isModifiable.toString();
        return this;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public String getChangeType() {
        return this.changeType;
    }

    public Parameter withChangeType(String changeType) {
        this.setChangeType(changeType);
        return this;
    }

    public void setChangeType(ChangeType changeType) {
        this.withChangeType(changeType);
    }

    public Parameter withChangeType(ChangeType changeType) {
        this.changeType = changeType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getParameterName() != null) {
            sb.append("ParameterName: ").append(this.getParameterName()).append(",");
        }
        if (this.getParameterType() != null) {
            sb.append("ParameterType: ").append(this.getParameterType()).append(",");
        }
        if (this.getParameterValue() != null) {
            sb.append("ParameterValue: ").append(this.getParameterValue()).append(",");
        }
        if (this.getNodeTypeSpecificValues() != null) {
            sb.append("NodeTypeSpecificValues: ").append(this.getNodeTypeSpecificValues()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getDataType() != null) {
            sb.append("DataType: ").append(this.getDataType()).append(",");
        }
        if (this.getAllowedValues() != null) {
            sb.append("AllowedValues: ").append(this.getAllowedValues()).append(",");
        }
        if (this.getIsModifiable() != null) {
            sb.append("IsModifiable: ").append(this.getIsModifiable()).append(",");
        }
        if (this.getChangeType() != null) {
            sb.append("ChangeType: ").append(this.getChangeType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)obj;
        if (other.getParameterName() == null ^ this.getParameterName() == null) {
            return false;
        }
        if (other.getParameterName() != null && !other.getParameterName().equals(this.getParameterName())) {
            return false;
        }
        if (other.getParameterType() == null ^ this.getParameterType() == null) {
            return false;
        }
        if (other.getParameterType() != null && !other.getParameterType().equals(this.getParameterType())) {
            return false;
        }
        if (other.getParameterValue() == null ^ this.getParameterValue() == null) {
            return false;
        }
        if (other.getParameterValue() != null && !other.getParameterValue().equals(this.getParameterValue())) {
            return false;
        }
        if (other.getNodeTypeSpecificValues() == null ^ this.getNodeTypeSpecificValues() == null) {
            return false;
        }
        if (other.getNodeTypeSpecificValues() != null && !other.getNodeTypeSpecificValues().equals(this.getNodeTypeSpecificValues())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getDataType() == null ^ this.getDataType() == null) {
            return false;
        }
        if (other.getDataType() != null && !other.getDataType().equals(this.getDataType())) {
            return false;
        }
        if (other.getAllowedValues() == null ^ this.getAllowedValues() == null) {
            return false;
        }
        if (other.getAllowedValues() != null && !other.getAllowedValues().equals(this.getAllowedValues())) {
            return false;
        }
        if (other.getIsModifiable() == null ^ this.getIsModifiable() == null) {
            return false;
        }
        if (other.getIsModifiable() != null && !other.getIsModifiable().equals(this.getIsModifiable())) {
            return false;
        }
        if (other.getChangeType() == null ^ this.getChangeType() == null) {
            return false;
        }
        return other.getChangeType() == null || other.getChangeType().equals(this.getChangeType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getParameterName() == null ? 0 : this.getParameterName().hashCode());
        hashCode = 31 * hashCode + (this.getParameterType() == null ? 0 : this.getParameterType().hashCode());
        hashCode = 31 * hashCode + (this.getParameterValue() == null ? 0 : this.getParameterValue().hashCode());
        hashCode = 31 * hashCode + (this.getNodeTypeSpecificValues() == null ? 0 : this.getNodeTypeSpecificValues().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getDataType() == null ? 0 : this.getDataType().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedValues() == null ? 0 : this.getAllowedValues().hashCode());
        hashCode = 31 * hashCode + (this.getIsModifiable() == null ? 0 : this.getIsModifiable().hashCode());
        hashCode = 31 * hashCode + (this.getChangeType() == null ? 0 : this.getChangeType().hashCode());
        return hashCode;
    }

    public Parameter clone() {
        try {
            return (Parameter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParameterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

