/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.Container;
import com.amazonaws.services.ecs.model.TaskOverride;
import com.amazonaws.services.ecs.model.transform.TaskMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Task
implements Serializable,
Cloneable,
StructuredPojo {
    private String taskArn;
    private String clusterArn;
    private String taskDefinitionArn;
    private String containerInstanceArn;
    private TaskOverride overrides;
    private String lastStatus;
    private String desiredStatus;
    private SdkInternalList<Container> containers;
    private String startedBy;
    private Long version;
    private String stoppedReason;
    private Date createdAt;
    private Date startedAt;
    private Date stoppedAt;
    private String group;

    public void setTaskArn(String taskArn) {
        this.taskArn = taskArn;
    }

    public String getTaskArn() {
        return this.taskArn;
    }

    public Task withTaskArn(String taskArn) {
        this.setTaskArn(taskArn);
        return this;
    }

    public void setClusterArn(String clusterArn) {
        this.clusterArn = clusterArn;
    }

    public String getClusterArn() {
        return this.clusterArn;
    }

    public Task withClusterArn(String clusterArn) {
        this.setClusterArn(clusterArn);
        return this;
    }

    public void setTaskDefinitionArn(String taskDefinitionArn) {
        this.taskDefinitionArn = taskDefinitionArn;
    }

    public String getTaskDefinitionArn() {
        return this.taskDefinitionArn;
    }

    public Task withTaskDefinitionArn(String taskDefinitionArn) {
        this.setTaskDefinitionArn(taskDefinitionArn);
        return this;
    }

    public void setContainerInstanceArn(String containerInstanceArn) {
        this.containerInstanceArn = containerInstanceArn;
    }

    public String getContainerInstanceArn() {
        return this.containerInstanceArn;
    }

    public Task withContainerInstanceArn(String containerInstanceArn) {
        this.setContainerInstanceArn(containerInstanceArn);
        return this;
    }

    public void setOverrides(TaskOverride overrides) {
        this.overrides = overrides;
    }

    public TaskOverride getOverrides() {
        return this.overrides;
    }

    public Task withOverrides(TaskOverride overrides) {
        this.setOverrides(overrides);
        return this;
    }

    public void setLastStatus(String lastStatus) {
        this.lastStatus = lastStatus;
    }

    public String getLastStatus() {
        return this.lastStatus;
    }

    public Task withLastStatus(String lastStatus) {
        this.setLastStatus(lastStatus);
        return this;
    }

    public void setDesiredStatus(String desiredStatus) {
        this.desiredStatus = desiredStatus;
    }

    public String getDesiredStatus() {
        return this.desiredStatus;
    }

    public Task withDesiredStatus(String desiredStatus) {
        this.setDesiredStatus(desiredStatus);
        return this;
    }

    public List<Container> getContainers() {
        if (this.containers == null) {
            this.containers = new SdkInternalList();
        }
        return this.containers;
    }

    public void setContainers(Collection<Container> containers) {
        if (containers == null) {
            this.containers = null;
            return;
        }
        this.containers = new SdkInternalList(containers);
    }

    public Task withContainers(Container ... containers) {
        if (this.containers == null) {
            this.setContainers((Collection<Container>)new SdkInternalList(containers.length));
        }
        for (Container ele : containers) {
            this.containers.add((Object)ele);
        }
        return this;
    }

    public Task withContainers(Collection<Container> containers) {
        this.setContainers(containers);
        return this;
    }

    public void setStartedBy(String startedBy) {
        this.startedBy = startedBy;
    }

    public String getStartedBy() {
        return this.startedBy;
    }

    public Task withStartedBy(String startedBy) {
        this.setStartedBy(startedBy);
        return this;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Long getVersion() {
        return this.version;
    }

    public Task withVersion(Long version) {
        this.setVersion(version);
        return this;
    }

    public void setStoppedReason(String stoppedReason) {
        this.stoppedReason = stoppedReason;
    }

    public String getStoppedReason() {
        return this.stoppedReason;
    }

    public Task withStoppedReason(String stoppedReason) {
        this.setStoppedReason(stoppedReason);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Task withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt;
    }

    public Date getStartedAt() {
        return this.startedAt;
    }

    public Task withStartedAt(Date startedAt) {
        this.setStartedAt(startedAt);
        return this;
    }

    public void setStoppedAt(Date stoppedAt) {
        this.stoppedAt = stoppedAt;
    }

    public Date getStoppedAt() {
        return this.stoppedAt;
    }

    public Task withStoppedAt(Date stoppedAt) {
        this.setStoppedAt(stoppedAt);
        return this;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public Task withGroup(String group) {
        this.setGroup(group);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTaskArn() != null) {
            sb.append("TaskArn: ").append(this.getTaskArn()).append(",");
        }
        if (this.getClusterArn() != null) {
            sb.append("ClusterArn: ").append(this.getClusterArn()).append(",");
        }
        if (this.getTaskDefinitionArn() != null) {
            sb.append("TaskDefinitionArn: ").append(this.getTaskDefinitionArn()).append(",");
        }
        if (this.getContainerInstanceArn() != null) {
            sb.append("ContainerInstanceArn: ").append(this.getContainerInstanceArn()).append(",");
        }
        if (this.getOverrides() != null) {
            sb.append("Overrides: ").append(this.getOverrides()).append(",");
        }
        if (this.getLastStatus() != null) {
            sb.append("LastStatus: ").append(this.getLastStatus()).append(",");
        }
        if (this.getDesiredStatus() != null) {
            sb.append("DesiredStatus: ").append(this.getDesiredStatus()).append(",");
        }
        if (this.getContainers() != null) {
            sb.append("Containers: ").append(this.getContainers()).append(",");
        }
        if (this.getStartedBy() != null) {
            sb.append("StartedBy: ").append(this.getStartedBy()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getStoppedReason() != null) {
            sb.append("StoppedReason: ").append(this.getStoppedReason()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getStartedAt() != null) {
            sb.append("StartedAt: ").append(this.getStartedAt()).append(",");
        }
        if (this.getStoppedAt() != null) {
            sb.append("StoppedAt: ").append(this.getStoppedAt()).append(",");
        }
        if (this.getGroup() != null) {
            sb.append("Group: ").append(this.getGroup());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Task)) {
            return false;
        }
        Task other = (Task)obj;
        if (other.getTaskArn() == null ^ this.getTaskArn() == null) {
            return false;
        }
        if (other.getTaskArn() != null && !other.getTaskArn().equals(this.getTaskArn())) {
            return false;
        }
        if (other.getClusterArn() == null ^ this.getClusterArn() == null) {
            return false;
        }
        if (other.getClusterArn() != null && !other.getClusterArn().equals(this.getClusterArn())) {
            return false;
        }
        if (other.getTaskDefinitionArn() == null ^ this.getTaskDefinitionArn() == null) {
            return false;
        }
        if (other.getTaskDefinitionArn() != null && !other.getTaskDefinitionArn().equals(this.getTaskDefinitionArn())) {
            return false;
        }
        if (other.getContainerInstanceArn() == null ^ this.getContainerInstanceArn() == null) {
            return false;
        }
        if (other.getContainerInstanceArn() != null && !other.getContainerInstanceArn().equals(this.getContainerInstanceArn())) {
            return false;
        }
        if (other.getOverrides() == null ^ this.getOverrides() == null) {
            return false;
        }
        if (other.getOverrides() != null && !other.getOverrides().equals(this.getOverrides())) {
            return false;
        }
        if (other.getLastStatus() == null ^ this.getLastStatus() == null) {
            return false;
        }
        if (other.getLastStatus() != null && !other.getLastStatus().equals(this.getLastStatus())) {
            return false;
        }
        if (other.getDesiredStatus() == null ^ this.getDesiredStatus() == null) {
            return false;
        }
        if (other.getDesiredStatus() != null && !other.getDesiredStatus().equals(this.getDesiredStatus())) {
            return false;
        }
        if (other.getContainers() == null ^ this.getContainers() == null) {
            return false;
        }
        if (other.getContainers() != null && !other.getContainers().equals(this.getContainers())) {
            return false;
        }
        if (other.getStartedBy() == null ^ this.getStartedBy() == null) {
            return false;
        }
        if (other.getStartedBy() != null && !other.getStartedBy().equals(this.getStartedBy())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getStoppedReason() == null ^ this.getStoppedReason() == null) {
            return false;
        }
        if (other.getStoppedReason() != null && !other.getStoppedReason().equals(this.getStoppedReason())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getStartedAt() == null ^ this.getStartedAt() == null) {
            return false;
        }
        if (other.getStartedAt() != null && !other.getStartedAt().equals(this.getStartedAt())) {
            return false;
        }
        if (other.getStoppedAt() == null ^ this.getStoppedAt() == null) {
            return false;
        }
        if (other.getStoppedAt() != null && !other.getStoppedAt().equals(this.getStoppedAt())) {
            return false;
        }
        if (other.getGroup() == null ^ this.getGroup() == null) {
            return false;
        }
        return other.getGroup() == null || other.getGroup().equals(this.getGroup());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTaskArn() == null ? 0 : this.getTaskArn().hashCode());
        hashCode = 31 * hashCode + (this.getClusterArn() == null ? 0 : this.getClusterArn().hashCode());
        hashCode = 31 * hashCode + (this.getTaskDefinitionArn() == null ? 0 : this.getTaskDefinitionArn().hashCode());
        hashCode = 31 * hashCode + (this.getContainerInstanceArn() == null ? 0 : this.getContainerInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.getOverrides() == null ? 0 : this.getOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getLastStatus() == null ? 0 : this.getLastStatus().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredStatus() == null ? 0 : this.getDesiredStatus().hashCode());
        hashCode = 31 * hashCode + (this.getContainers() == null ? 0 : this.getContainers().hashCode());
        hashCode = 31 * hashCode + (this.getStartedBy() == null ? 0 : this.getStartedBy().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getStoppedReason() == null ? 0 : this.getStoppedReason().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getStartedAt() == null ? 0 : this.getStartedAt().hashCode());
        hashCode = 31 * hashCode + (this.getStoppedAt() == null ? 0 : this.getStoppedAt().hashCode());
        hashCode = 31 * hashCode + (this.getGroup() == null ? 0 : this.getGroup().hashCode());
        return hashCode;
    }

    public Task clone() {
        try {
            return (Task)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TaskMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

