/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.config.model.ResourceCount;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class GetDiscoveredResourceCountsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private Long totalDiscoveredResources;
    private SdkInternalList<ResourceCount> resourceCounts;
    private String nextToken;

    public void setTotalDiscoveredResources(Long totalDiscoveredResources) {
        this.totalDiscoveredResources = totalDiscoveredResources;
    }

    public Long getTotalDiscoveredResources() {
        return this.totalDiscoveredResources;
    }

    public GetDiscoveredResourceCountsResult withTotalDiscoveredResources(Long totalDiscoveredResources) {
        this.setTotalDiscoveredResources(totalDiscoveredResources);
        return this;
    }

    public List<ResourceCount> getResourceCounts() {
        if (this.resourceCounts == null) {
            this.resourceCounts = new SdkInternalList();
        }
        return this.resourceCounts;
    }

    public void setResourceCounts(Collection<ResourceCount> resourceCounts) {
        if (resourceCounts == null) {
            this.resourceCounts = null;
            return;
        }
        this.resourceCounts = new SdkInternalList(resourceCounts);
    }

    public GetDiscoveredResourceCountsResult withResourceCounts(ResourceCount ... resourceCounts) {
        if (this.resourceCounts == null) {
            this.setResourceCounts((Collection<ResourceCount>)new SdkInternalList(resourceCounts.length));
        }
        for (ResourceCount ele : resourceCounts) {
            this.resourceCounts.add((Object)ele);
        }
        return this;
    }

    public GetDiscoveredResourceCountsResult withResourceCounts(Collection<ResourceCount> resourceCounts) {
        this.setResourceCounts(resourceCounts);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetDiscoveredResourceCountsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTotalDiscoveredResources() != null) {
            sb.append("TotalDiscoveredResources: ").append(this.getTotalDiscoveredResources()).append(",");
        }
        if (this.getResourceCounts() != null) {
            sb.append("ResourceCounts: ").append(this.getResourceCounts()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDiscoveredResourceCountsResult)) {
            return false;
        }
        GetDiscoveredResourceCountsResult other = (GetDiscoveredResourceCountsResult)obj;
        if (other.getTotalDiscoveredResources() == null ^ this.getTotalDiscoveredResources() == null) {
            return false;
        }
        if (other.getTotalDiscoveredResources() != null && !other.getTotalDiscoveredResources().equals(this.getTotalDiscoveredResources())) {
            return false;
        }
        if (other.getResourceCounts() == null ^ this.getResourceCounts() == null) {
            return false;
        }
        if (other.getResourceCounts() != null && !other.getResourceCounts().equals(this.getResourceCounts())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTotalDiscoveredResources() == null ? 0 : this.getTotalDiscoveredResources().hashCode());
        hashCode = 31 * hashCode + (this.getResourceCounts() == null ? 0 : this.getResourceCounts().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public GetDiscoveredResourceCountsResult clone() {
        try {
            return (GetDiscoveredResourceCountsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

