/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.jdbc.core;

import com.simba.athena.dsi.core.impl.DSIConnection;
import com.simba.athena.dsi.core.interfaces.IEnvironment;
import com.simba.athena.dsi.core.utilities.ConnSettingRequestMap;
import com.simba.athena.dsi.exceptions.BadAuthException;
import com.simba.athena.jdbc.core.DSDriver;
import com.simba.athena.jdbc.exceptions.CommonJDBCMessageKey;
import com.simba.athena.support.exceptions.DiagState;
import com.simba.athena.support.exceptions.ErrorException;
import java.sql.DriverManager;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class LoginTimeoutConnection
extends DSIConnection {
    protected static final int LOGIN_TIMEOUT_DISABLED = 0;

    protected LoginTimeoutConnection(IEnvironment iEnvironment) throws ErrorException {
        super(iEnvironment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void connect(final ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        final int n = this.getLoginTimeOut();
        if (0 < n) {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Future<Boolean> future = null;
            try {
                future = executorService.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws ErrorException {
                        LoginTimeoutConnection.this.establishConnection(connSettingRequestMap, n);
                        return true;
                    }
                });
                future.get(n, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
                future.cancel(true);
                this.handleException(timeoutException);
            }
            catch (ExecutionException executionException) {
                future.cancel(true);
                this.handleException(executionException);
            }
            catch (Exception exception) {
                future.cancel(true);
                this.handleException(exception);
            }
            finally {
                executorService.shutdown();
            }
        } else {
            this.establishConnection(connSettingRequestMap, 0);
        }
    }

    protected abstract void establishConnection(ConnSettingRequestMap var1, int var2) throws ErrorException, BadAuthException;

    protected void handleException(Exception exception) throws ErrorException {
        if (null != exception && exception instanceof TimeoutException) {
            throw new ErrorException(DiagState.DIAG_CONN_TIMEOUT_EXPIRED, 105, CommonJDBCMessageKey.CONN_LOGINTIMEOUT_ERR.name(), new String[]{"None"});
        }
        if (null != exception) {
            Throwable throwable = exception.getCause();
            if (null != throwable && throwable instanceof ErrorException) {
                throw (ErrorException)throwable;
            }
            if (null != exception.getMessage()) {
                throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_UNEXP_SESSION_ERR.name(), exception.getMessage());
            }
        }
        throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_UNEXP_SESSION_ERR.name(), "Unknown");
    }

    private int getLoginTimeOut() {
        return DriverManager.getLoginTimeout();
    }
}

