/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.model;

import com.simba.athena.amazonaws.services.athenastreamingservice.model.GetQueryResultsStreamResult;
import com.simba.athena.athena.api.AJClient;
import com.simba.athena.athena.api.AJExecutionContext;
import com.simba.athena.athena.dataengine.AJStatementType;
import com.simba.athena.athena.model.AJStreamRowBuffer;
import com.simba.athena.athena.utilities.AJUtilities;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.concurrent.ArrayBlockingQueue;

public class AJStreamProducer
implements Runnable {
    private static final int END_OF_STREAM = -1;
    private static final char END_OF_ROW = '\n';
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private final ArrayBlockingQueue<AJStreamRowBuffer> m_queue;
    private final AJClient m_client;
    private ILogger m_logger;
    private final AJExecutionContext m_ctx;
    private volatile boolean m_isRunning;
    private boolean m_isFirstRun = true;
    private ErrorException m_exception = null;
    private final StringBuilder m_sb;
    private final boolean m_isSelectOrValueStatment;

    public AJStreamProducer(ILogger iLogger, AJClient aJClient, ArrayBlockingQueue<AJStreamRowBuffer> arrayBlockingQueue, AJExecutionContext aJExecutionContext, AJStatementType aJStatementType) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_logger = iLogger;
        this.m_queue = arrayBlockingQueue;
        this.m_client = aJClient;
        this.m_ctx = aJExecutionContext;
        this.m_isRunning = true;
        this.m_isSelectOrValueStatment = AJStatementType.SELECT_OR_VALUES_STATEMENT == aJStatementType;
        this.m_sb = new StringBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            while (this.m_ctx.m_hasMoreRows || this.m_isFirstRun) {
                this.m_isFirstRun = false;
                if (!this.m_isRunning) {
                    LogUtilities.logDebug("Shutting down stream publisher.", this.m_logger);
                    this.m_queue.offer(new AJStreamRowBuffer());
                    return;
                }
                try {
                    this.processNextStream();
                }
                catch (Exception exception) {
                    this.m_client.checkAndThrowException(exception, this.m_ctx);
                }
            }
        }
        catch (ErrorException errorException) {
            LogUtilities.logDebug(errorException, this.m_logger);
            AJStreamProducer aJStreamProducer = this;
            synchronized (aJStreamProducer) {
                this.m_exception = errorException;
            }
            this.m_queue.offer(new AJStreamRowBuffer());
        }
    }

    public synchronized void checkException() throws ErrorException {
        if (null != this.m_exception) {
            this.m_queue.offer(new AJStreamRowBuffer());
            throw this.m_exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNextStream() throws Exception {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        GetQueryResultsStreamResult getQueryResultsStreamResult = this.m_client.fetchStreamResults(this.m_ctx);
        InputStream inputStream = getQueryResultsStreamResult.getResults();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, UTF8_CHARSET);
        this.m_ctx.m_nextToken = null;
        boolean bl = this.m_isSelectOrValueStatment;
        this.m_sb.setLength(0);
        try {
            while (true) {
                if (!this.m_isRunning) {
                    LogUtilities.logDebug("Shutting down stream read.", this.m_logger);
                    this.m_queue.offer(new AJStreamRowBuffer());
                    return;
                }
                int n = inputStreamReader.read();
                if (-1 == n) {
                    throw new Exception("Unexpected stream termination.");
                }
                if (10 == n) {
                    int n2 = inputStreamReader.read();
                    AJStreamRowBuffer aJStreamRowBuffer = new AJStreamRowBuffer();
                    if (-1 != n2) {
                        if (!this.m_ctx.m_hasResultSetMetadata) {
                            aJStreamRowBuffer.setResultSetMetadata(this.m_sb.toString());
                            this.m_queue.put(aJStreamRowBuffer);
                            this.m_ctx.m_hasResultSetMetadata = true;
                        } else if (!bl) {
                            aJStreamRowBuffer.setResultRow(this.m_sb.toString());
                            this.m_queue.put(aJStreamRowBuffer);
                        }
                        bl = false;
                        this.m_sb.setLength(0);
                        this.m_sb.append((char)n2);
                        continue;
                    }
                    try {
                        if (bl) break;
                        String string = this.m_sb.toString();
                        AJUtilities.deserializeRow(string);
                        aJStreamRowBuffer.setResultRow(string);
                        this.m_queue.put(aJStreamRowBuffer);
                    }
                    catch (Exception exception) {
                        LogUtilities.logDebug("Failed to deserialize last Row, treat it as next page token. Details: " + exception, this.m_logger);
                        this.m_ctx.m_nextToken = this.m_sb.toString();
                    }
                    break;
                }
                this.m_sb.append((char)n);
            }
            if (null != this.m_ctx.m_nextToken) {
                this.m_ctx.m_hasMoreRows = true;
            } else {
                this.m_ctx.m_hasMoreRows = false;
                this.m_queue.put(new AJStreamRowBuffer());
            }
        }
        finally {
            try {
                inputStreamReader.close();
                inputStream.close();
            }
            catch (Exception exception) {
                LogUtilities.logDebug("Exception at stream close. Details: " + exception, this.m_logger);
            }
        }
    }

    public void shutdown() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_isRunning = false;
    }
}

