/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.dataengine;

import com.simba.athena.athena.api.AJClient;
import com.simba.athena.athena.api.AJExecutionContext;
import com.simba.athena.athena.core.AJConnection;
import com.simba.athena.athena.core.AJSettings;
import com.simba.athena.athena.dataengine.AJResultSet;
import com.simba.athena.athena.dataengine.AJStatementType;
import com.simba.athena.athena.dataengine.AJStreamResultSet;
import com.simba.athena.dsi.core.interfaces.IStatement;
import com.simba.athena.dsi.dataengine.impl.DSIEmptyResultSet;
import com.simba.athena.dsi.dataengine.impl.DSISimpleRowCountResult;
import com.simba.athena.dsi.dataengine.interfaces.IQueryExecutor;
import com.simba.athena.dsi.dataengine.utilities.ExecutionContexts;
import com.simba.athena.dsi.dataengine.utilities.ExecutionResults;
import com.simba.athena.dsi.dataengine.utilities.ParameterInputValue;
import com.simba.athena.dsi.dataengine.utilities.ParameterMetadata;
import com.simba.athena.dsi.dataengine.utilities.TypeMetadata;
import com.simba.athena.dsi.exceptions.BadDefaultParamException;
import com.simba.athena.dsi.exceptions.ExecutingException;
import com.simba.athena.dsi.exceptions.OperationCanceledException;
import com.simba.athena.dsi.exceptions.ParsingException;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Map;

public class AJQueryExecutor
implements IQueryExecutor {
    private ILogger m_logger;
    private IWarningListener m_warningListener;
    private AJConnection m_connection;
    private IStatement m_statement;
    private AJClient m_client;
    private final AJSettings m_settings;
    private String m_query;
    private AJStatementType m_stmtType;
    private AJExecutionContext m_execContext = new AJExecutionContext();
    private ExecutionResults m_results = new ExecutionResults();
    private ArrayList<ParameterMetadata> m_parameters = new ArrayList();

    public AJQueryExecutor(ILogger iLogger, IWarningListener iWarningListener, AJConnection aJConnection, AJSettings aJSettings, String string, IStatement iStatement, AJStatementType aJStatementType, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_logger = iLogger;
        this.m_warningListener = iWarningListener;
        this.m_connection = aJConnection;
        this.m_client = this.m_connection.getClient();
        this.m_settings = aJSettings;
        this.m_query = string;
        this.m_stmtType = aJStatementType;
        this.m_execContext.m_statement = this.m_statement = iStatement;
        this.m_execContext.m_fetchWithStream = false;
        if (AJStatementType.ROW_COUNT_STATEMENT != aJStatementType) {
            if (!bl && AJStatementType.SELECT_OR_VALUES_STATEMENT == aJStatementType) {
                this.m_execContext.setQuery("SELECT * FROM (" + this.m_query + ") T LIMIT 0");
                this.m_client.executeQuery(this.m_execContext);
                this.m_results.addResultSet(new AJResultSet(this.m_logger, this.m_warningListener, this.m_connection, this.m_settings, this.m_execContext, this.m_stmtType));
            } else {
                this.m_results.addResultSet(new DSIEmptyResultSet());
            }
        } else {
            this.m_results.addRowCountResult(new DSISimpleRowCountResult(-1L));
        }
    }

    @Override
    public void clearCancel() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_client.clearCancel(this.m_execContext);
    }

    @Override
    public void cancelExecute() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_client.cancelQuery(this.m_execContext);
    }

    @Override
    public void clearPushedParamData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void execute(ExecutionContexts executionContexts, IWarningListener iWarningListener) throws BadDefaultParamException, ParsingException, ExecutingException, OperationCanceledException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, executionContexts, iWarningListener);
        if (!this.m_client.checkCancelFlag(this.m_execContext)) {
            if (AJStatementType.ROW_COUNT_STATEMENT != this.m_stmtType) {
                this.m_results.getResults().clear();
            }
            this.m_execContext.setQuery(this.m_query);
            this.m_client.executeQuery(this.m_execContext);
            if (AJStatementType.ROW_COUNT_STATEMENT != this.m_stmtType) {
                this.m_execContext.m_fetchWithStream = this.m_settings.m_useStreamClient;
                if (this.m_execContext.m_fetchWithStream) {
                    this.m_results.addResultSet(new AJStreamResultSet(this.m_logger, this.m_warningListener, this.m_connection, this.m_settings, this.m_execContext, this.m_stmtType));
                } else {
                    this.m_results.addResultSet(new AJResultSet(this.m_logger, this.m_warningListener, this.m_connection, this.m_settings, this.m_execContext, this.m_stmtType));
                }
            }
        }
    }

    @Override
    public void finalizePushedParamData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_parameters;
    }

    @Override
    public int getNumParams() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return 0;
    }

    @Override
    public ExecutionResults getResults() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_results;
    }

    @Override
    public void pushParamData(int n, ParameterInputValue parameterInputValue) throws BadDefaultParamException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, parameterInputValue);
    }

    @Override
    public void pushMappedParamTypes(Map<Integer, TypeMetadata> map) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }
}

