/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.core;

import com.simba.athena.athena.core.AJEnvironment;
import com.simba.athena.athena.exceptions.AJMessageKey;
import com.simba.athena.dsi.core.impl.DSILogger;
import com.simba.athena.dsi.core.interfaces.IEnvironment;
import com.simba.athena.dsi.core.utilities.Variant;
import com.simba.athena.jdbc.core.DSDriver;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import com.simba.athena.support.exceptions.ExceptionBuilder;
import com.simba.athena.support.exceptions.ExceptionUtilities;
import java.text.MessageFormat;

public class AJDriver
extends DSDriver {
    private static final String LOG_NAME = "AthenaJDBC_Driver";
    public static final String RESOURCE_NAME = "messages";
    public static ExceptionBuilder s_AJMessages = new ExceptionBuilder(101);
    public static final String AJ_DRIVER_VERSION = MessageFormat.format("{0,number,00}.{1,number,00}.{2,number,00}.{3,number,0000}", 2, 0, 6, 1008);
    private DSILogger m_log;

    public AJDriver() throws ErrorException {
        super("AthenaJDBC");
        StringBuilder stringBuilder = new StringBuilder(ExceptionUtilities.getPackageName(this.getClass()));
        stringBuilder.append(".");
        stringBuilder.append(RESOURCE_NAME);
        this.m_msgSrc.registerMessages(stringBuilder.toString(), 101, "AthenaJDBC");
        this.m_msgSrc.setVendorName("Simba");
        this.setDefaultProperties();
    }

    @Override
    public IEnvironment createEnvironment() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getDriverLog(), new Object[0]);
        return new AJEnvironment(this);
    }

    @Override
    public ILogger getDriverLog() {
        if (null == this.m_log) {
            this.m_log = new DSILogger(LOG_NAME);
        }
        return this.m_log;
    }

    public void unload() {
        this.m_log = null;
    }

    private void setDefaultProperties() throws ErrorException {
        try {
            this.setProperty(3, new Variant(0, "Simba Athena JDBC Driver"));
            this.setProperty(5, new Variant(0, AJ_DRIVER_VERSION));
            this.setProperty(1000, new Variant(5, (short)1));
        }
        catch (Throwable throwable) {
            throw s_AJMessages.createGeneralException(AJMessageKey.DRIVER_DEFAULT_PROP_ERR.name());
        }
    }
}

