/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import blbutil.Utilities;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public final class BGZIPOutputStream
extends OutputStream {
    private static final boolean USE_GZIP = true;
    private static final int NOCOMPRESS_XTRA_BYTES = 5;
    private static final int MAX_INPUT_BYTES = 65505;
    private static final int MAX_OUTPUT_BYTES = 65510;
    private final boolean writeEmptyBlock;
    private final Deflater gzipDef;
    private final CRC32 crc;
    private final OutputStream os;
    private final byte[] input = new byte[65505];
    private final byte[] output = new byte[65511];
    private int iSize = 0;

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            Utilities.exit("usage: java -ea -jar bgzip.jar [file1] [file2] ...");
        }
        for (String string : stringArray) {
            if (string.endsWith(".gz")) {
                Utilities.exit("ERROR: input filename ends in \".gz\"");
            }
            File file = new File(string);
            File file2 = new File(string + ".gz");
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 FileOutputStream fileOutputStream = new FileOutputStream(file2);
                 BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                 BGZIPOutputStream bGZIPOutputStream = new BGZIPOutputStream(bufferedOutputStream, true);){
                byte[] byArray = new byte[2000];
                int n = ((InputStream)fileInputStream).read(byArray);
                while (n != -1) {
                    bGZIPOutputStream.write(byArray, 0, n);
                    n = ((InputStream)fileInputStream).read(byArray);
                }
            }
        }
    }

    public BGZIPOutputStream(OutputStream outputStream, boolean bl) {
        if (outputStream == null) {
            throw new NullPointerException(OutputStream.class.toString());
        }
        this.writeEmptyBlock = bl;
        this.gzipDef = new Deflater(-1, true);
        this.os = outputStream;
        this.crc = new CRC32();
        assert (this.crc.getValue() == 0L);
    }

    private void compressAndFlushBuffer() throws IOException {
        this.crc.update(this.input, 0, this.iSize);
        int n = (int)this.crc.getValue();
        this.gzipDef.setInput(this.input, 0, this.iSize);
        this.gzipDef.finish();
        int n2 = this.gzipDef.deflate(this.output, 0, this.output.length, 2);
        if (n2 > 65510) {
            n2 = this.setOutputNoCompression();
        }
        BGZIPOutputStream.writeBgzipBlock(this.iSize, n, this.output, n2, this.os);
        this.gzipDef.reset();
        this.crc.reset();
        this.iSize = 0;
    }

    private int setOutputNoCompression() {
        this.output[0] = 1;
        this.output[1] = (byte)(this.iSize & 0xFF);
        this.output[2] = (byte)(this.iSize >> 8 & 0xFF);
        this.output[3] = ~this.output[1];
        this.output[4] = ~this.output[2];
        System.arraycopy(this.input, 0, this.output, 5, this.iSize);
        return this.iSize + 5;
    }

    private static void writeBgzipBlock(int n, int n2, byte[] byArray, int n3, OutputStream outputStream) throws IOException {
        if (n > 65536) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        BGZIPOutputStream.writeBGZIPHeader(n3, outputStream);
        outputStream.write(byArray, 0, n3);
        BGZIPOutputStream.writeInt(n2, outputStream);
        BGZIPOutputStream.writeInt(n, outputStream);
    }

    private static void writeBGZIPHeader(int n, OutputStream outputStream) throws IOException {
        int n2 = n + 25;
        if (n2 >> 16 != 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        byte[] byArray = new byte[]{31, -117, 8, 4, 0, 0, 0, 0, 0, -1, 6, 0, 66, 67, 2, 0, (byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF)};
        outputStream.write(byArray);
    }

    private static void writeInt(int n, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(n & 0xFF));
        outputStream.write((byte)(n >> 8 & 0xFF));
        outputStream.write((byte)(n >> 16 & 0xFF));
        outputStream.write((byte)(n >> 24 & 0xFF));
    }

    @Override
    public void write(int n) throws IOException {
        this.input[this.iSize++] = (byte)n;
        if (this.iSize == 65505) {
            this.compressAndFlushBuffer();
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.input.length - this.iSize;
        while (n2 - n >= n3) {
            System.arraycopy(byArray, n, this.input, this.iSize, n3);
            this.iSize += n3;
            n += n3;
            n2 -= n3;
            assert (this.iSize == 65505);
            this.compressAndFlushBuffer();
            assert (this.iSize == 0);
            n3 = this.input.length - this.iSize;
        }
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.input, this.iSize, n2);
            this.iSize += n2;
        }
    }

    @Override
    public void flush() throws IOException {
        this.compressAndFlushBuffer();
        this.os.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.iSize > 0) {
            this.compressAndFlushBuffer();
        }
        if (this.writeEmptyBlock) {
            this.compressAndFlushBuffer();
        }
        this.os.close();
    }
}

