/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.rgraph;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.smsd.algorithm.rgraph.CDKMCS;
import org.openscience.cdk.smsd.algorithm.rgraph.CDKRMap;
import org.openscience.cdk.smsd.helper.FinalMappings;
import org.openscience.cdk.tools.manipulator.BondManipulator;

@Deprecated
public class CDKRMapHandler {
    private List<Map<Integer, Integer>> mappings;
    private IAtomContainer source;
    private IAtomContainer target;
    private boolean timeoutFlag = false;

    public IAtomContainer getSource() {
        return this.source;
    }

    public void setSource(IAtomContainer aSource) {
        this.source = aSource;
    }

    public IAtomContainer getTarget() {
        return this.target;
    }

    public void setTarget(IAtomContainer aTarget) {
        this.target = aTarget;
    }

    public void calculateOverlapsAndReduce(IAtomContainer molecule1, IAtomContainer molecule2, boolean shouldMatchBonds) throws CDKException {
        this.setSource(molecule1);
        this.setTarget(molecule2);
        this.setMappings(new ArrayList<Map<Integer, Integer>>());
        if (this.getSource().getAtomCount() == 1 || this.getTarget().getAtomCount() == 1) {
            List<CDKRMap> overlaps = CDKMCS.checkSingleAtomCases(this.getSource(), this.getTarget());
            int nAtomsMatched = overlaps.size();
            int n = nAtomsMatched = nAtomsMatched > 0 ? 1 : 0;
            if (nAtomsMatched > 0) {
                this.identifySingleAtomsMatchedParts(overlaps, this.getSource(), this.getTarget());
            }
        } else {
            List<List<CDKRMap>> overlaps = CDKMCS.search(this.getSource(), this.getTarget(), new BitSet(), new BitSet(), true, true, shouldMatchBonds);
            List<List<CDKRMap>> reducedList = this.removeSubGraph(overlaps);
            Stack<List<CDKRMap>> allMaxOverlaps = this.getAllMaximum(reducedList);
            while (!allMaxOverlaps.empty()) {
                List<List<CDKRMap>> maxOverlapsAtoms = CDKRMapHandler.makeAtomsMapOfBondsMap(allMaxOverlaps.peek(), this.getSource(), this.getTarget());
                this.identifyMatchedParts(maxOverlapsAtoms, this.getSource(), this.getTarget());
                allMaxOverlaps.pop();
            }
        }
        FinalMappings.getInstance().set(this.getMappings());
    }

    public void calculateOverlapsAndReduceExactMatch(IAtomContainer molecule1, IAtomContainer molecule2, boolean shouldMatchBonds) throws CDKException {
        this.setSource(molecule1);
        this.setTarget(molecule2);
        this.setMappings(new ArrayList<Map<Integer, Integer>>());
        if (this.getSource().getAtomCount() == 1 || this.getTarget().getAtomCount() == 1) {
            List<CDKRMap> overlaps = CDKMCS.checkSingleAtomCases(this.getSource(), this.getTarget());
            int nAtomsMatched = overlaps.size();
            int n = nAtomsMatched = nAtomsMatched > 0 ? 1 : 0;
            if (nAtomsMatched > 0) {
                this.identifySingleAtomsMatchedParts(overlaps, this.getSource(), this.getTarget());
            }
        } else {
            List<List<CDKRMap>> overlaps = CDKMCS.search(this.getSource(), this.getTarget(), new BitSet(), new BitSet(), true, true, shouldMatchBonds);
            List<List<CDKRMap>> reducedList = this.removeSubGraph(overlaps);
            Stack<List<CDKRMap>> allMaxOverlaps = this.getAllMaximum(reducedList);
            while (!allMaxOverlaps.empty()) {
                List<List<CDKRMap>> maxOverlapsAtoms = CDKRMapHandler.makeAtomsMapOfBondsMap(allMaxOverlaps.peek(), this.getSource(), this.getTarget());
                this.identifyMatchedParts(maxOverlapsAtoms, this.getSource(), this.getTarget());
                allMaxOverlaps.pop();
            }
        }
        FinalMappings.getInstance().set(this.getMappings());
    }

    public void calculateSubGraphs(IAtomContainer molecule1, IAtomContainer molecule2, boolean shouldMatchBonds) throws CDKException {
        this.setSource(molecule1);
        this.setTarget(molecule2);
        this.setMappings(new ArrayList<Map<Integer, Integer>>());
        if (this.getSource().getAtomCount() == 1 || this.getTarget().getAtomCount() == 1) {
            List<CDKRMap> overlaps = CDKMCS.checkSingleAtomCases(this.getSource(), this.getTarget());
            int nAtomsMatched = overlaps.size();
            int n = nAtomsMatched = nAtomsMatched > 0 ? 1 : 0;
            if (nAtomsMatched > 0) {
                this.identifySingleAtomsMatchedParts(overlaps, this.getSource(), this.getTarget());
            }
        } else {
            List<List<CDKRMap>> overlaps = CDKMCS.getSubgraphMaps(this.getSource(), this.getTarget(), shouldMatchBonds);
            List<List<CDKRMap>> reducedList = this.removeSubGraph(overlaps);
            Stack<List<CDKRMap>> allMaxOverlaps = this.getAllMaximum(reducedList);
            while (!allMaxOverlaps.empty()) {
                List<List<CDKRMap>> maxOverlapsAtoms = CDKRMapHandler.makeAtomsMapOfBondsMap(allMaxOverlaps.peek(), this.getSource(), this.getTarget());
                this.identifyMatchedParts(maxOverlapsAtoms, this.getSource(), this.getTarget());
                allMaxOverlaps.pop();
            }
        }
        FinalMappings.getInstance().set(this.getMappings());
    }

    public void calculateIsomorphs(IAtomContainer molecule1, IAtomContainer molecule2, boolean shouldMatchBonds) throws CDKException {
        this.setSource(molecule1);
        this.setTarget(molecule2);
        this.setMappings(new ArrayList<Map<Integer, Integer>>());
        if (this.getSource().getAtomCount() == 1 || this.getTarget().getAtomCount() == 1) {
            List<CDKRMap> overlaps = CDKMCS.checkSingleAtomCases(this.getSource(), this.getTarget());
            int nAtomsMatched = overlaps.size();
            int n = nAtomsMatched = nAtomsMatched > 0 ? 1 : 0;
            if (nAtomsMatched > 0) {
                this.identifySingleAtomsMatchedParts(overlaps, this.getSource(), this.getTarget());
            }
        } else {
            List<List<CDKRMap>> overlaps = CDKMCS.getIsomorphMaps(this.getSource(), this.getTarget(), shouldMatchBonds);
            List<List<CDKRMap>> reducedList = this.removeSubGraph(overlaps);
            Stack<List<CDKRMap>> allMaxOverlaps = this.getAllMaximum(reducedList);
            while (!allMaxOverlaps.empty()) {
                List<List<CDKRMap>> maxOverlapsAtoms = CDKRMapHandler.makeAtomsMapOfBondsMap(allMaxOverlaps.peek(), this.getSource(), this.getTarget());
                this.identifyMatchedParts(maxOverlapsAtoms, this.getSource(), this.getTarget());
                allMaxOverlaps.pop();
            }
        }
        FinalMappings.getInstance().set(this.getMappings());
    }

    protected List<List<CDKRMap>> removeSubGraph(List<List<CDKRMap>> overlaps) {
        ArrayList<List<CDKRMap>> reducedList = new ArrayList<List<CDKRMap>>(overlaps);
        for (int i = 0; i < overlaps.size(); ++i) {
            List<CDKRMap> graphI = overlaps.get(i);
            for (int j = i + 1; j < overlaps.size(); ++j) {
                List<CDKRMap> graphJ = overlaps.get(j);
                if (graphI.size() == graphJ.size()) continue;
                if (this.isSubgraph(graphJ, graphI)) {
                    reducedList.remove(graphI);
                    continue;
                }
                if (!this.isSubgraph(graphI, graphJ)) continue;
                reducedList.remove(graphJ);
            }
        }
        return reducedList;
    }

    protected List<CDKRMap> removeRedundantMappingsForSingleAtomCase(List<CDKRMap> overlaps) {
        ArrayList<CDKRMap> reducedList = new ArrayList<CDKRMap>();
        reducedList.add(overlaps.get(0));
        return reducedList;
    }

    private static List<List<CDKRMap>> makeAtomsMapOfBondsMap(List<CDKRMap> rMapList, IAtomContainer graph1, IAtomContainer graph2) {
        if (rMapList == null) {
            return null;
        }
        List<List<CDKRMap>> result = null;
        if (rMapList.size() == 1) {
            result = CDKRMapHandler.makeAtomsMapOfBondsMapSingleBond(rMapList, graph1, graph2);
        } else {
            ArrayList<CDKRMap> resultLocal = new ArrayList<CDKRMap>();
            for (int i = 0; i < rMapList.size(); ++i) {
                IBond qBond = graph1.getBond(rMapList.get(i).getId1());
                IBond tBond = graph2.getBond(rMapList.get(i).getId2());
                IAtom[] qAtoms = BondManipulator.getAtomArray(qBond);
                IAtom[] tAtoms = BondManipulator.getAtomArray(tBond);
                for (int j = 0; j < 2; ++j) {
                    List<IBond> bondsConnectedToAtom1j = graph1.getConnectedBondsList(qAtoms[j]);
                    for (int k = 0; k < bondsConnectedToAtom1j.size(); ++k) {
                        if (bondsConnectedToAtom1j.get(k).equals(qBond)) continue;
                        IBond testBond = bondsConnectedToAtom1j.get(k);
                        for (int m = 0; m < rMapList.size(); ++m) {
                            if (rMapList.get(m).getId1() != graph1.indexOf(testBond)) continue;
                            IBond testBond2 = graph2.getBond(rMapList.get(m).getId2());
                            for (int n = 0; n < 2; ++n) {
                                CDKRMap map2;
                                List<IBond> bondsToTest = graph2.getConnectedBondsList(tAtoms[n]);
                                if (!bondsToTest.contains(testBond2)) continue;
                                CDKRMap map = j == n ? new CDKRMap(graph1.indexOf(qAtoms[0]), graph2.indexOf(tAtoms[0])) : new CDKRMap(graph1.indexOf(qAtoms[1]), graph2.indexOf(tAtoms[0]));
                                if (!resultLocal.contains(map)) {
                                    resultLocal.add(map);
                                }
                                if (resultLocal.contains(map2 = j == n ? new CDKRMap(graph1.indexOf(qAtoms[1]), graph2.indexOf(tAtoms[1])) : new CDKRMap(graph1.indexOf(qAtoms[0]), graph2.indexOf(tAtoms[1])))) continue;
                                resultLocal.add(map2);
                            }
                        }
                    }
                }
            }
            result = new ArrayList<List<CDKRMap>>();
            result.add(resultLocal);
        }
        return result;
    }

    private static List<List<CDKRMap>> makeAtomsMapOfBondsMapSingleBond(List<CDKRMap> list, IAtomContainer sourceGraph, IAtomContainer targetGraph) {
        if (list == null) {
            return null;
        }
        HashMap<IBond, IBond> bondMap = new HashMap<IBond, IBond>(list.size());
        for (CDKRMap solBondMap : list) {
            int id1 = solBondMap.getId1();
            int id2 = solBondMap.getId2();
            IBond qBond = sourceGraph.getBond(id1);
            IBond tBond = targetGraph.getBond(id2);
            bondMap.put(qBond, tBond);
        }
        ArrayList<CDKRMap> result1 = new ArrayList<CDKRMap>();
        ArrayList<CDKRMap> result2 = new ArrayList<CDKRMap>();
        for (IBond qbond : sourceGraph.bonds()) {
            if (!bondMap.containsKey(qbond)) continue;
            IBond tbond = (IBond)bondMap.get(qbond);
            CDKRMap map00 = null;
            CDKRMap map01 = null;
            CDKRMap map10 = null;
            CDKRMap map11 = null;
            if (qbond.getBegin().getSymbol().equals(tbond.getBegin().getSymbol()) && qbond.getEnd().getSymbol().equals(tbond.getEnd().getSymbol())) {
                map00 = new CDKRMap(sourceGraph.indexOf(qbond.getBegin()), targetGraph.indexOf(tbond.getBegin()));
                map11 = new CDKRMap(sourceGraph.indexOf(qbond.getEnd()), targetGraph.indexOf(tbond.getEnd()));
                if (!result1.contains(map00)) {
                    result1.add(map00);
                }
                if (!result1.contains(map11)) {
                    result1.add(map11);
                }
            }
            if (!qbond.getBegin().getSymbol().equals(tbond.getEnd().getSymbol()) || !qbond.getEnd().getSymbol().equals(tbond.getBegin().getSymbol())) continue;
            map01 = new CDKRMap(sourceGraph.indexOf(qbond.getBegin()), targetGraph.indexOf(tbond.getEnd()));
            map10 = new CDKRMap(sourceGraph.indexOf(qbond.getEnd()), targetGraph.indexOf(tbond.getBegin()));
            if (!result2.contains(map01)) {
                result2.add(map01);
            }
            if (result2.contains(map10)) continue;
            result2.add(map10);
        }
        ArrayList<List<CDKRMap>> result = new ArrayList<List<CDKRMap>>();
        if (result1.size() == result2.size()) {
            result.add(result1);
            result.add(result2);
        } else if (result1.size() > result2.size()) {
            result.add(result1);
        } else {
            result.add(result2);
        }
        return result;
    }

    protected List getMaximum(List overlaps) {
        ArrayList list = null;
        int count = 0;
        for (Object o : overlaps) {
            ArrayList arrayList = (ArrayList)o;
            if (arrayList.size() <= count) continue;
            list = arrayList;
            count = arrayList.size();
        }
        return list;
    }

    protected Stack<List<CDKRMap>> getAllMaximum(List<List<CDKRMap>> overlaps) {
        Stack<ArrayList<CDKRMap>> allMaximumMappings = null;
        int count = -1;
        for (List<CDKRMap> arrayList : overlaps) {
            ArrayList<CDKRMap> list;
            if (arrayList.size() > count) {
                list = new ArrayList<CDKRMap>(arrayList);
                count = arrayList.size();
                allMaximumMappings = new Stack<ArrayList<CDKRMap>>();
                allMaximumMappings.push(list);
                continue;
            }
            if (arrayList.size() != count) continue;
            list = new ArrayList<CDKRMap>(arrayList);
            count = arrayList.size();
            allMaximumMappings.push(list);
        }
        return allMaximumMappings;
    }

    protected void identifyMatchedParts(List<List<CDKRMap>> list, IAtomContainer source, IAtomContainer target) {
        ArrayList<IAtom> array1 = new ArrayList<IAtom>();
        ArrayList<IAtom> array2 = new ArrayList<IAtom>();
        for (List<CDKRMap> rMap : list) {
            TreeMap<Integer, Integer> atomNumbersFromContainer = new TreeMap<Integer, Integer>();
            for (CDKRMap rmap : rMap) {
                IAtom sourceAtom = source.getAtom(rmap.getId1());
                IAtom targetAtom = target.getAtom(rmap.getId2());
                array1.add(sourceAtom);
                array2.add(targetAtom);
                int indexI = source.indexOf(sourceAtom);
                int indexJ = target.indexOf(targetAtom);
                atomNumbersFromContainer.put(indexI, indexJ);
            }
            this.getMappings().add(atomNumbersFromContainer);
        }
    }

    protected void identifySingleAtomsMatchedParts(List<CDKRMap> list, IAtomContainer source, IAtomContainer target) {
        ArrayList<IAtom> array1 = new ArrayList<IAtom>();
        ArrayList<IAtom> array2 = new ArrayList<IAtom>();
        TreeMap<Integer, Integer> atomNumbersFromContainer = new TreeMap<Integer, Integer>();
        for (CDKRMap rmap : list) {
            IAtom sAtom = source.getAtom(rmap.getId1());
            IAtom tAtom = target.getAtom(rmap.getId2());
            array1.add(sAtom);
            array2.add(tAtom);
            int indexI = source.indexOf(sAtom);
            int indexJ = target.indexOf(tAtom);
            atomNumbersFromContainer.put(indexI, indexJ);
            this.getMappings().add(atomNumbersFromContainer);
        }
    }

    protected boolean isSubgraph(List<CDKRMap> rmaps1, List<CDKRMap> rmaps2) {
        List rmaps2clone = (List)((ArrayList)rmaps2).clone();
        for (CDKRMap rmap1 : rmaps1) {
            boolean found = false;
            for (int i = 0; i < rmaps2clone.size(); ++i) {
                CDKRMap rmap2 = (CDKRMap)rmaps2clone.get(i);
                if (!this.isSameRMap(rmap1, rmap2)) continue;
                rmaps2clone.remove(i);
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    protected boolean isSameRMap(CDKRMap sourceRMap, CDKRMap targetRMap) {
        return sourceRMap.getId1() == targetRMap.getId1() && sourceRMap.getId2() == targetRMap.getId2();
    }

    public List<Map<Integer, Integer>> getMappings() {
        return this.mappings;
    }

    public void setMappings(List<Map<Integer, Integer>> mappings) {
        this.mappings = mappings;
    }

    public boolean isTimeoutFlag() {
        return this.timeoutFlag;
    }

    public void setTimeoutFlag(boolean timeoutFlag) {
        this.timeoutFlag = timeoutFlag;
    }
}

