/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.tools.HOSECodeGenerator;
import org.openscience.cdk.tools.LonePairElectronChecker;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class ProtonAffinityHOSEDescriptor
extends AbstractAtomicDescriptor {
    private static final String[] NAMES = new String[]{"protonAffiHOSE"};
    int maxSpheresToUse = 10;
    private Affinitydb db = new Affinitydb();

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#ionizationPotential", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    @Override
    public DescriptorValue calculate(IAtom atom, IAtomContainer container) {
        double value = 0.0;
        try {
            int i = container.indexOf(atom);
            if (i < 0) {
                throw new CDKException("atom was not a memeber of the provided container");
            }
            container = container.clone();
            atom = container.getAtom(i);
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(container);
            LonePairElectronChecker lpcheck = new LonePairElectronChecker();
            lpcheck.saturate(container);
        }
        catch (CDKException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), NAMES, null);
        }
        catch (CloneNotSupportedException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), NAMES, null);
        }
        value = this.db.extractAffinity(container, atom);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(value), NAMES);
    }

    private boolean familyHalogen(IAtom atom) {
        String symbol = atom.getSymbol();
        return symbol.equals("F") || symbol.equals("Cl") || symbol.equals("Br") || symbol.equals("I");
    }

    @Override
    public String[] getParameterNames() {
        return new String[0];
    }

    @Override
    public Object getParameterType(String name) {
        return null;
    }

    private static List<String> extractInfo(String str) {
        StringBuffer idEdited = new StringBuffer();
        StringBuffer valEdited = new StringBuffer();
        int strlen = str.length();
        boolean foundSpace = false;
        boolean countSpace = false;
        boolean foundDigit = false;
        for (int i = 0; i < strlen; ++i) {
            if (!foundDigit && Character.isLetter(str.charAt(i))) {
                foundDigit = true;
            }
            if (!foundDigit) continue;
            if (Character.isWhitespace(str.charAt(i))) {
                if (countSpace) break;
                foundSpace = true;
                continue;
            }
            if (foundSpace) {
                valEdited.append(str.charAt(i));
                continue;
            }
            idEdited.append(str.charAt(i));
        }
        ArrayList<String> objec = new ArrayList<String>();
        objec.add(idEdited.toString());
        objec.add(valEdited.toString());
        return objec;
    }

    private class Affinitydb {
        HashMap<String, HashMap<String, Double>> listGroup = new HashMap();
        HashMap<String, HashMap<String, Double>> listGroupS = new HashMap();

        public double extractAffinity(IAtomContainer container, IAtom atom) {
            String name = "";
            String nameS = "";
            HashMap<Object, Object> hoseVSenergy = new HashMap();
            HashMap<Object, Object> hoseVSenergyS = new HashMap();
            if (ProtonAffinityHOSEDescriptor.this.familyHalogen(atom)) {
                name = "X_AffiProton_HOSE.db";
                nameS = "X_AffiProton_HOSE_S.db";
                if (this.listGroup.containsKey(name)) {
                    hoseVSenergy = this.listGroup.get(name);
                    hoseVSenergyS = this.listGroupS.get(nameS);
                } else {
                    String path = "org/openscience/cdk/qsar/descriptors/atomic/data/" + name;
                    String pathS = "org/openscience/cdk/qsar/descriptors/atomic/data/" + nameS;
                    InputStream ins = this.getClass().getClassLoader().getResourceAsStream(path);
                    BufferedReader insr = new BufferedReader(new InputStreamReader(ins));
                    hoseVSenergy = this.extractAttributes(insr);
                    ins = this.getClass().getClassLoader().getResourceAsStream(pathS);
                    insr = new BufferedReader(new InputStreamReader(ins));
                    hoseVSenergyS = this.extractAttributes(insr);
                }
            } else {
                return 0.0;
            }
            try {
                HOSECodeGenerator hcg = new HOSECodeGenerator();
                int exactSphere = 0;
                String hoseCode = "";
                for (int spheres = ProtonAffinityHOSEDescriptor.this.maxSpheresToUse; spheres > 0; --spheres) {
                    hcg.getSpheres(container, atom, spheres, true);
                    List<IAtom> atoms = hcg.getNodesInSphere(spheres);
                    if (atoms.size() == 0) continue;
                    exactSphere = spheres;
                    hoseCode = hcg.getHOSECode(container, atom, spheres, true);
                    if (hoseVSenergy.containsKey(hoseCode)) {
                        return (Double)hoseVSenergy.get(hoseCode);
                    }
                    if (!hoseVSenergyS.containsKey(hoseCode)) break;
                    return (Double)hoseVSenergyS.get(hoseCode);
                }
                for (int i = 0; i < 3; ++i) {
                    for (int plusMinus = 0; plusMinus < 2; ++plusMinus) {
                        int sign = -1;
                        if (plusMinus == 1) {
                            sign = 1;
                        }
                        StringTokenizer st = new StringTokenizer(hoseCode, "()/");
                        StringBuilder hoseCodeBuffer = new StringBuilder();
                        int sum = exactSphere + sign * (i + 1);
                        for (int k = 0; k < sum; ++k) {
                            if (st.hasMoreTokens()) {
                                String partcode = st.nextToken();
                                hoseCodeBuffer.append(partcode);
                            }
                            if (k == 0) {
                                hoseCodeBuffer.append('(');
                                continue;
                            }
                            if (k == 3) {
                                hoseCodeBuffer.append(')');
                                continue;
                            }
                            hoseCodeBuffer.append('/');
                        }
                        String hoseCodeBU = hoseCodeBuffer.toString();
                        if (!hoseVSenergyS.containsKey(hoseCodeBU)) continue;
                        return (Double)hoseVSenergyS.get(hoseCodeBU);
                    }
                }
            }
            catch (CDKException e) {
                e.printStackTrace();
            }
            return 0.0;
        }

        private HashMap<String, Double> extractAttributes(BufferedReader input) {
            HashMap<String, Double> hoseVSenergy = new HashMap<String, Double>();
            try {
                String line;
                while ((line = input.readLine()) != null) {
                    List values;
                    if (line.startsWith("#") || ((String)(values = ProtonAffinityHOSEDescriptor.extractInfo(line)).get(1)).isEmpty()) continue;
                    hoseVSenergy.put((String)values.get(0), Double.valueOf((String)values.get(1)));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return hoseVSenergy;
        }
    }
}

