/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.exponentialfamily;

import eu.amidst.core.distribution.ConditionalDistribution;
import eu.amidst.core.exponentialfamily.EF_ConditionalDistribution;
import eu.amidst.core.exponentialfamily.EF_Distribution;
import eu.amidst.core.exponentialfamily.MomentParameters;
import eu.amidst.core.exponentialfamily.SufficientStatistics;
import eu.amidst.core.models.BayesianNetwork;
import eu.amidst.core.models.DAG;
import eu.amidst.core.models.ParentSet;
import eu.amidst.core.utils.CompoundVector;
import eu.amidst.core.utils.Vector;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.DistributionType;
import eu.amidst.core.variables.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class EF_BayesianNetwork
extends EF_Distribution {
    List<EF_ConditionalDistribution> distributionList;
    int sizeSS;

    public EF_BayesianNetwork() {
        this.distributionList = new ArrayList<EF_ConditionalDistribution>();
        this.sizeSS = 0;
        this.naturalParameters = this.createEmtpyCompoundVector();
        this.momentParameters = null;
    }

    public EF_BayesianNetwork(BayesianNetwork network) {
        this.distributionList = new ArrayList<EF_ConditionalDistribution>(network.getNumberOfVars());
        this.sizeSS = 0;
        for (ConditionalDistribution dist : network.getConditionalDistributions()) {
            Object ef_dist = dist.toEFConditionalDistribution();
            this.distributionList.add(((EF_ConditionalDistribution)ef_dist).getVariable().getVarID(), (EF_ConditionalDistribution)ef_dist);
            this.sizeSS += ((EF_Distribution)ef_dist).sizeOfSufficientStatistics();
        }
        CompoundVector vectorNatural = this.createEmtpyCompoundVector();
        for (EF_ConditionalDistribution dist : this.distributionList) {
            vectorNatural.setVectorByPosition(dist.getVariable().getVarID(), dist.getNaturalParameters());
        }
        this.naturalParameters = vectorNatural;
        this.momentParameters = null;
    }

    public EF_BayesianNetwork(DAG dag) {
        this(dag.getParentSets());
    }

    public EF_BayesianNetwork(List<ParentSet> parentSets) {
        this.distributionList = new ArrayList<EF_ConditionalDistribution>(parentSets.size());
        this.sizeSS = 0;
        for (ParentSet parentSet : parentSets) {
            Object ef_dist = ((DistributionType)parentSet.getMainVar().getDistributionType()).newEFConditionalDistribution(parentSet.getParents());
            this.distributionList.add(((EF_ConditionalDistribution)ef_dist).getVariable().getVarID(), (EF_ConditionalDistribution)ef_dist);
            this.sizeSS += ((EF_Distribution)ef_dist).sizeOfSufficientStatistics();
        }
        CompoundVector vectorNatural = this.createEmtpyCompoundVector();
        for (EF_ConditionalDistribution dist : this.distributionList) {
            vectorNatural.setVectorByPosition(dist.getVariable().getVarID(), dist.getNaturalParameters());
        }
        this.naturalParameters = vectorNatural;
        this.momentParameters = null;
    }

    public BayesianNetwork toBayesianNetwork(DAG dag) {
        return new BayesianNetwork(dag, EF_BayesianNetwork.toConditionalDistribution(this.distributionList));
    }

    public static List<ConditionalDistribution> toConditionalDistribution(List<EF_ConditionalDistribution> ef_dists) {
        ConditionalDistribution[] dists = new ConditionalDistribution[ef_dists.size()];
        ef_dists.stream().forEach(dist -> {
            dists[dist.getVariable().getVarID()] = dist.toConditionalDistribution();
        });
        return Arrays.asList(dists);
    }

    public void setDistributionList(List<EF_ConditionalDistribution> distributionList_) {
        this.distributionList = distributionList_;
        this.sizeSS = 0;
        for (EF_ConditionalDistribution ef_dist : this.distributionList) {
            this.sizeSS += ef_dist.sizeOfSufficientStatistics();
        }
        CompoundVector vectorNatural = this.createEmtpyCompoundVector();
        for (EF_ConditionalDistribution dist : this.distributionList) {
            vectorNatural.setVectorByPosition(dist.getVariable().getVarID(), dist.getNaturalParameters());
        }
        this.naturalParameters = vectorNatural;
        this.momentParameters = null;
    }

    public List<EF_ConditionalDistribution> getDistributionList() {
        return this.distributionList;
    }

    public EF_ConditionalDistribution getDistribution(Variable var) {
        return this.distributionList.get(var.getVarID());
    }

    @Override
    public void updateNaturalFromMomentParameters() {
        CompoundVector globalMomentsParam = (CompoundVector)this.momentParameters;
        CompoundVector vectorNatural = this.createEmtpyCompoundVector();
        this.distributionList.stream().forEach(w -> {
            MomentParameters localMomentParam = (MomentParameters)globalMomentsParam.getVectorByPosition(w.getVariable().getVarID());
            w.setMomentParameters(localMomentParam);
            vectorNatural.setVectorByPosition(w.getVariable().getVarID(), w.getNaturalParameters());
        });
        this.naturalParameters = vectorNatural;
    }

    @Override
    public void updateMomentFromNaturalParameters() {
        throw new UnsupportedOperationException("This method does not apply in this case!");
    }

    @Override
    public SufficientStatistics getSufficientStatistics(Assignment data) {
        CompoundVector vectorSS = this.createEmtpyCompoundVector();
        this.distributionList.stream().forEach(w -> vectorSS.setVectorByPosition(w.getVariable().getVarID(), w.getSufficientStatistics(data)));
        return vectorSS;
    }

    @Override
    public int sizeOfSufficientStatistics() {
        return this.sizeSS;
    }

    @Override
    public double computeLogBaseMeasure(Assignment dataInstance) {
        return this.distributionList.stream().mapToDouble(w -> w.computeLogBaseMeasure(dataInstance)).sum();
    }

    @Override
    public double computeLogNormalizer() {
        return this.distributionList.stream().mapToDouble(w -> w.computeLogNormalizer()).sum();
    }

    @Override
    public Vector createZeroVector() {
        return this.createZeroCompoundVector();
    }

    @Override
    public SufficientStatistics createInitSufficientStatistics() {
        return new CompoundVector(this.distributionList.stream().map(w -> w.createInitSufficientStatistics()).collect(Collectors.toList()));
    }

    private CompoundVector createZeroCompoundVector() {
        return new CompoundVector(this.distributionList.stream().map(w -> w.createZeroVector()).collect(Collectors.toList()));
    }

    private CompoundVector createEmtpyCompoundVector() {
        return new CompoundVector(this.distributionList.size(), this.sizeOfSufficientStatistics());
    }

    public boolean equal_efBN(EF_BayesianNetwork ef_bayesianNetwork, double threshold) {
        for (EF_ConditionalDistribution this_dist : this.getDistributionList()) {
            EF_ConditionalDistribution ef_dist = ef_bayesianNetwork.getDistribution(this_dist.getVariable());
            if (!this_dist.getClass().getName().equals(ef_dist.getClass().getName())) {
                return false;
            }
            List<Variable> this_Vars = this_dist.getConditioningVariables();
            List<Variable> ef_Vars = ef_dist.getConditioningVariables();
            if (this_Vars.size() != ef_Vars.size()) {
                return false;
            }
            for (Variable var : this_Vars) {
                if (ef_Vars.contains(var)) continue;
                return false;
            }
        }
        return this.getNaturalParameters().equalsVector(ef_bayesianNetwork.getNaturalParameters(), threshold);
    }
}

