/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.datastream.filereaders.arffFileReader;

import eu.amidst.core.datastream.Attribute;
import eu.amidst.core.datastream.Attributes;
import eu.amidst.core.datastream.DataInstance;
import eu.amidst.core.datastream.DataStream;
import eu.amidst.core.datastream.filereaders.DataFileWriter;
import eu.amidst.core.utils.Utils;
import eu.amidst.core.variables.StateSpaceType;
import eu.amidst.core.variables.StateSpaceTypeEnum;
import eu.amidst.core.variables.stateSpaceTypes.FiniteStateSpace;
import eu.amidst.core.variables.stateSpaceTypes.RealStateSpace;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.DecimalFormat;

public class ARFFDataWriter
implements DataFileWriter {
    public static DecimalFormat decimalFormat = new DecimalFormat("#");

    public static void writeToARFFFile(DataStream<? extends DataInstance> dataStream, String path) throws IOException {
        FileWriter fw = new FileWriter(path);
        fw.write("@relation dataset\n\n");
        for (Attribute att : dataStream.getAttributes()) {
            fw.write(ARFFDataWriter.attributeToARFFString(att) + "\n");
        }
        fw.write("\n\n@data\n\n");
        dataStream.stream().forEach(e -> {
            try {
                fw.write(ARFFDataWriter.dataInstanceToARFFString(dataStream.getAttributes(), e) + "\n");
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        });
        fw.close();
    }

    @Override
    public String getFileExtension() {
        return "arff";
    }

    @Override
    public void writeToFile(DataStream<? extends DataInstance> dataStream, String path) throws IOException {
        ARFFDataWriter.writeToARFFFile(dataStream, path);
    }

    public static String attributeToARFFString(Attribute att) {
        if (((StateSpaceType)att.getStateSpaceType()).getStateSpaceTypeEnum() == StateSpaceTypeEnum.REAL) {
            return "@attribute " + att.getName() + " real";
        }
        if (((StateSpaceType)att.getStateSpaceType()).getStateSpaceTypeEnum() == StateSpaceTypeEnum.FINITE_SET) {
            StringBuilder stringBuilder = new StringBuilder("@attribute " + att.getName() + " {");
            FiniteStateSpace stateSpace = (FiniteStateSpace)att.getStateSpaceType();
            stateSpace.getStatesNames().stream().limit(stateSpace.getNumberOfStates() - 1).forEach(e -> stringBuilder.append(e + ", "));
            stringBuilder.append(stateSpace.getStatesName(stateSpace.getNumberOfStates() - 1) + "}");
            return stringBuilder.toString();
        }
        if (((StateSpaceType)att.getStateSpaceType()).getStateSpaceTypeEnum() == StateSpaceTypeEnum.SPARSE_FINITE_SET) {
            return "@attribute " + att.getName() + " SparseMultinomial " + att.getNumberOfStates();
        }
        throw new IllegalArgumentException("Unknown SateSapaceType");
    }

    public static String attributeToARFFStringWithIndex(Attribute att, boolean includeRanges) {
        if (((StateSpaceType)att.getStateSpaceType()).getStateSpaceTypeEnum() == StateSpaceTypeEnum.REAL) {
            if (includeRanges && !att.getName().equalsIgnoreCase("SEQUENCE_ID") && !att.getName().equalsIgnoreCase("TIME_ID")) {
                return "@attribute " + att.getName() + " " + att.getIndex() + " real [" + ((RealStateSpace)att.getStateSpaceType()).getMinInterval() + "," + ((RealStateSpace)att.getStateSpaceType()).getMaxInterval() + "]";
            }
            return "@attribute " + att.getName() + " " + att.getIndex() + " real";
        }
        if (((StateSpaceType)att.getStateSpaceType()).getStateSpaceTypeEnum() == StateSpaceTypeEnum.FINITE_SET) {
            StringBuilder stringBuilder = new StringBuilder("@attribute " + att.getName() + " " + att.getIndex() + " {");
            FiniteStateSpace stateSpace = (FiniteStateSpace)att.getStateSpaceType();
            stateSpace.getStatesNames().stream().limit(stateSpace.getNumberOfStates() - 1).forEach(e -> stringBuilder.append(e + ", "));
            stringBuilder.append(stateSpace.getStatesName(stateSpace.getNumberOfStates() - 1) + "}");
            return stringBuilder.toString();
        }
        throw new IllegalArgumentException("Unknown SateSapaceType");
    }

    public static String dataInstanceToARFFString(DataInstance assignment) {
        return ARFFDataWriter.dataInstanceToARFFString(assignment.getAttributes(), assignment);
    }

    public static String dataInstanceToARFFString(Attributes atts, DataInstance assignment) {
        StringBuilder builder = new StringBuilder(atts.getNumberOfAttributes() * 2);
        for (int i = 0; i < atts.getNumberOfAttributes() - 1; ++i) {
            Attribute att = atts.getFullListOfAttributes().get(i);
            builder.append(ARFFDataWriter.dataInstanceToARFFString(att, assignment, ","));
        }
        Attribute att = atts.getFullListOfAttributes().get(atts.getNumberOfAttributes() - 1);
        builder.append(ARFFDataWriter.dataInstanceToARFFString(att, assignment, ""));
        return builder.toString();
    }

    public static String dataInstanceToARFFString(Attribute att, DataInstance assignment, String separator) {
        StringBuilder builder = new StringBuilder();
        if (Utils.isMissingValue(assignment.getValue(att))) {
            builder.append("?,");
        } else if (((StateSpaceType)att.getStateSpaceType()).getStateSpaceTypeEnum() == StateSpaceTypeEnum.FINITE_SET) {
            FiniteStateSpace stateSpace = (FiniteStateSpace)att.getStateSpaceType();
            String nameState = stateSpace.getStatesName((int)assignment.getValue(att));
            builder.append(nameState + separator);
        } else if (((StateSpaceType)att.getStateSpaceType()).getStateSpaceTypeEnum() == StateSpaceTypeEnum.REAL) {
            if (att.isSpecialAttribute() || att.isTimeId()) {
                builder.append(decimalFormat.format(assignment.getValue(att)) + separator);
            } else {
                builder.append(assignment.getValue(att) + separator);
            }
        } else if (((StateSpaceType)att.getStateSpaceType()).getStateSpaceTypeEnum() == StateSpaceTypeEnum.SPARSE_FINITE_SET) {
            int val = (int)assignment.getValue(att);
            builder.append(val + separator);
        } else {
            throw new IllegalArgumentException("Illegal State Space Type: " + (Object)((Object)((StateSpaceType)att.getStateSpaceType()).getStateSpaceTypeEnum()));
        }
        return builder.toString();
    }
}

