/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.datastream;

import eu.amidst.core.datastream.Attributes;
import eu.amidst.core.datastream.DataInstance;
import eu.amidst.core.datastream.DataOnMemory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

public class DataOnMemoryListContainer<E extends DataInstance>
implements DataOnMemory<E> {
    List<E> instanceList;
    Attributes attributes;
    double id = Double.NaN;

    public DataOnMemoryListContainer(Attributes attributes_) {
        this.instanceList = new ArrayList();
        this.attributes = attributes_;
    }

    public DataOnMemoryListContainer(Attributes attributes_, List<E> instanceList) {
        this.instanceList = new ArrayList();
        for (DataInstance dataInstance : instanceList) {
            this.instanceList.add(dataInstance);
        }
        this.attributes = attributes_;
    }

    public void add(E data) {
        this.instanceList.add(data);
    }

    public void addAll(Collection<E> data) {
        this.instanceList.addAll(data);
    }

    public void set(int id, E data) {
        this.instanceList.set(id, data);
    }

    @Override
    public int getNumberOfDataInstances() {
        return this.instanceList.size();
    }

    @Override
    public E getDataInstance(int i) {
        return (E)((DataInstance)this.instanceList.get(i));
    }

    @Override
    public List<E> getList() {
        return this.instanceList;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public Stream<E> stream() {
        return this.instanceList.stream();
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    @Override
    public void restart() {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (DataInstance e : this.instanceList) {
            builder.append(e.toString());
            builder.append("\n");
        }
        return builder.toString();
    }

    public void setId(double id) {
        this.id = id;
    }

    @Override
    public double getBatchID() {
        return this.id;
    }
}

