/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.iterators;

import choco.kernel.common.util.disposable.PoolManager;
import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.common.util.iterators.IStored;

public final class ArrayIterator<E>
extends DisposableIterator<E>
implements IStored {
    private static final ThreadLocal<PoolManager<ArrayIterator>> manager = new ThreadLocal();
    private E[] elements;
    private int size;
    private int cursor;
    private boolean isStored;

    private ArrayIterator() {
    }

    public static <E> ArrayIterator<E> getIterator(E[] elements, int size) {
        ArrayIterator<E> it;
        PoolManager<ArrayIterator<E>> tmanager = manager.get();
        if (tmanager == null) {
            tmanager = new PoolManager();
            manager.set(tmanager);
        }
        if ((it = tmanager.getE()) == null) {
            it = new ArrayIterator<E>();
        }
        super.init(elements, size);
        return it;
    }

    public static <E> ArrayIterator<E> getIterator(E[] elements) {
        ArrayIterator<E> it;
        PoolManager<ArrayIterator<E>> tmanager = manager.get();
        if (tmanager == null) {
            tmanager = new PoolManager();
            manager.set(tmanager);
        }
        if ((it = tmanager.getE()) == null) {
            it = new ArrayIterator<E>();
        }
        super.init(elements, elements.length);
        return it;
    }

    private void init(E[] someElements, int aSize) {
        super.init();
        this.elements = someElements;
        this.size = aSize;
        this.cursor = 0;
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.size;
    }

    @Override
    public E next() {
        return this.elements[this.cursor++];
    }

    @Override
    public void dispose() {
        super.dispose();
        manager.get().returnE(this);
    }

    @Override
    public void push() {
        this.isStored = true;
    }

    @Override
    public void pop() {
        this.isStored = false;
    }

    @Override
    public boolean isStored() {
        return this.isStored;
    }
}

