/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.csv;

import com.garmin.fit.Field;
import com.garmin.fit.Fit;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgListener;
import com.garmin.fit.csv.CSVWriter;
import java.util.Collection;

public class MesgDataCSVWriter
implements MesgListener {
    private CSVWriter csv;
    private boolean showInvalidsAsEmptyCells = false;

    public MesgDataCSVWriter(String string) {
        this.csv = new CSVWriter(string);
    }

    public void close() {
        this.csv.close();
    }

    public void showInvalidsAsEmptyCells() {
        this.showInvalidsAsEmptyCells = true;
    }

    @Override
    public void onMesg(Mesg mesg) {
        Collection<Field> collection = mesg.getFields();
        for (Field field : collection) {
            int n;
            String string = field.getStringValue(0, n = mesg.GetActiveSubFieldIndex(field.getNum()));
            if (string == null || this.showInvalidsAsEmptyCells && string.equals(Fit.baseTypeInvalidMap.get(field.getType(n)).toString())) {
                string = "";
            }
            for (int i = 1; i < field.getNumValues(); ++i) {
                string = string + "|";
                String string2 = field.getStringValue(i, n);
                if (string2 == null) continue;
                string = string + string2;
            }
            string = string.replaceAll("\"", "\"\"");
            string = "\"" + string + "\"";
            String string3 = field.getUnits(n);
            if (string3.isEmpty()) {
                this.csv.set(mesg.getName() + "." + field.getName(n), string);
                continue;
            }
            this.csv.set(mesg.getName() + "." + field.getName(n) + "[" + string3 + "]", string);
        }
        this.csv.writeln();
    }
}

