/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.data.simple;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.corehunter.data.BiAllelicGenotypeData;
import org.jamesframework.core.subset.SubsetSolution;
import uno.informatics.common.io.IOUtilities;
import uno.informatics.common.io.RowReader;
import uno.informatics.common.io.RowWriter;
import uno.informatics.data.SimpleEntity;
import uno.informatics.data.io.FileType;
import uno.informatics.data.pojo.DataPojo;
import uno.informatics.data.pojo.SimpleEntityPojo;

public class SimpleBiAllelicGenotypeData
extends DataPojo
implements BiAllelicGenotypeData {
    private static final long serialVersionUID = 1L;
    private static final String ID_HEADER = "X";
    private static final String NAMES_HEADER = "NAME";
    private static final String IDENTIFIERS_HEADER = "ID";
    private static final String SELECTED_HEADER = "SELECTED";
    private final byte[][] alleleScores;
    private final String[] markerNames;

    public SimpleBiAllelicGenotypeData(SimpleEntity[] itemHeaders, String[] markerNames, byte[][] alleleScores) {
        this("Biallelic marker data", itemHeaders, markerNames, alleleScores);
    }

    public SimpleBiAllelicGenotypeData(String datasetName, SimpleEntity[] itemHeaders, String[] markerNames, byte[][] alleleScores) {
        super(datasetName, itemHeaders);
        int i;
        int n = alleleScores.length;
        int m = -1;
        if (n == 0) {
            throw new IllegalArgumentException("No data (zero rows).");
        }
        for (i = 0; i < n; ++i) {
            byte[] geno = alleleScores[i];
            if (geno == null) {
                throw new IllegalArgumentException(String.format("Allele scores not defined for item %d.", i));
            }
            if (m == -1) {
                m = geno.length;
                if (m == 0) {
                    throw new IllegalArgumentException(String.format("No markers (zero columns) for item %d.", i));
                }
            } else if (geno.length != m) {
                throw new IllegalArgumentException(String.format("Incorrect number of markers for item %d. Expected: %d, actual: %d.", i, m, geno.length));
            }
            for (int j = 0; j < m; ++j) {
                if (geno[j] == -128 || geno[j] >= 0 && geno[j] <= 2) continue;
                throw new IllegalArgumentException(String.format("Unexpected value at data row %d and data column %d. Got: %d (allowed: 0, 1, 2).", i, j, geno[j]));
            }
        }
        this.alleleScores = new byte[n][m];
        for (i = 0; i < n; ++i) {
            this.alleleScores[i] = Arrays.copyOf(alleleScores[i], m);
        }
        if (markerNames == null) {
            this.markerNames = new String[m];
        } else {
            if (markerNames.length != m) {
                throw new IllegalArgumentException(String.format("Incorrect number of marker names provided. Expected: %d, actual: %d.", m, markerNames.length));
            }
            this.markerNames = Arrays.copyOf(markerNames, m);
        }
    }

    public static SimpleBiAllelicGenotypeData readData(Path filePath, FileType type) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("File path not defined.");
        }
        if (!filePath.toFile().exists()) {
            throw new IOException("File does not exist : " + filePath + ".");
        }
        if (type == null) {
            throw new IllegalArgumentException("File type not defined.");
        }
        if (type != FileType.TXT && type != FileType.CSV) {
            throw new IllegalArgumentException(String.format("Only file types TXT and CSV are supported. Got: %s.", new Object[]{type}));
        }
        Throwable throwable = null;
        try (RowReader reader = IOUtilities.createRowReader(filePath, type, 16, 32);){
            if (reader == null || !reader.ready()) {
                throw new IOException("Can not create reader for file " + filePath + ". File may be empty.");
            }
            if (!reader.hasNextRow()) {
                throw new IOException("File is empty.");
            }
            ArrayList<String[]> rows = new ArrayList<String[]>();
            while (reader.nextRow()) {
                rows.add(reader.getRowCellsAsStringArray());
            }
            if (rows.isEmpty()) {
                throw new IOException("File is empty.");
            }
            int numCols = rows.stream().mapToInt(row -> ((String[])row).length).max().getAsInt();
            for (int r = 0; r < rows.size(); ++r) {
                String[] row2 = (String[])rows.get(r);
                if (row2.length < numCols) {
                    row2 = Arrays.copyOf(row2, numCols);
                }
                rows.set(r, row2);
            }
            String[] firstRow = (String[])rows.get(0);
            if (firstRow.length == 0 || !Objects.equals(firstRow[0], IDENTIFIERS_HEADER)) {
                throw new IOException("Missing header row/column ID.");
            }
            boolean withNames = firstRow.length >= 2 && Objects.equals(firstRow[1], NAMES_HEADER);
            int numHeaderCols = 1;
            if (withNames) {
                ++numHeaderCols;
            }
            int numHeaderRows = 1;
            int n = rows.size() - numHeaderRows;
            if (n == 0) {
                throw new IOException("No data rows.");
            }
            int m = numCols - numHeaderCols;
            if (m == 0) {
                throw new IOException("No data columns.");
            }
            String[] markerNames = new String[m];
            for (int c = numHeaderCols; c < firstRow.length; ++c) {
                markerNames[c - numHeaderCols] = firstRow[c];
            }
            String[] itemNames = new String[n];
            String[] itemIdentifiers = new String[n];
            byte[][] alleleScores = new byte[n][m];
            for (int i = 0; i < n; ++i) {
                String[] row3 = (String[])rows.get(numHeaderRows + i);
                itemIdentifiers[i] = row3[0];
                itemNames[i] = withNames ? row3[1] : itemIdentifiers[i];
                for (int j = 0; j < m; ++j) {
                    String s = row3[numHeaderCols + j];
                    try {
                        alleleScores[i][j] = s == null ? -128 : (int)Byte.parseByte(s.trim());
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        throw new IOException(String.format("Invalid allele score at row %d, column %d. Expected integer value 0/1/2, got: \"%s\".", numHeaderRows + i, numHeaderCols + j, s), ex);
                    }
                }
            }
            SimpleEntity[] headers = new SimpleEntity[n];
            for (int i = 0; i < n; ++i) {
                headers[i] = itemNames[i] != null ? new SimpleEntityPojo(itemIdentifiers[i], itemNames[i]) : new SimpleEntityPojo(itemIdentifiers[i]);
            }
            try {
                SimpleBiAllelicGenotypeData i = new SimpleBiAllelicGenotypeData(filePath.getFileName().toString(), headers, markerNames, alleleScores);
                return i;
            }
            catch (IllegalArgumentException ex) {
                try {
                    throw new IOException(ex.getMessage());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public int getNumberOfMarkers() {
        return this.markerNames.length;
    }

    @Override
    public String getMarkerName(int markerIndex) throws ArrayIndexOutOfBoundsException {
        return this.markerNames[markerIndex];
    }

    @Override
    public int getNumberOfAlleles(int markerIndex) {
        return 2;
    }

    @Override
    public int getTotalNumberOfAlleles() {
        return 2 * this.getNumberOfMarkers();
    }

    @Override
    public String getAlleleName(int markerIndex, int alleleIndex) throws ArrayIndexOutOfBoundsException {
        if (alleleIndex < 0 || alleleIndex > 1) {
            throw new ArrayIndexOutOfBoundsException(alleleIndex);
        }
        return alleleIndex + "";
    }

    @Override
    public byte getAlleleScore(int id, int markerIndex) {
        return this.alleleScores[id][markerIndex];
    }

    @Override
    public double getAlleleFrequency(int id, int markerIndex, int alleleIndex) {
        byte score = this.alleleScores[id][markerIndex];
        if (alleleIndex < 0 || alleleIndex > 1) {
            throw new ArrayIndexOutOfBoundsException(alleleIndex);
        }
        if (score == -128) {
            return Double.NaN;
        }
        double f = (double)score / 2.0;
        return alleleIndex == 1 ? f : 1.0 - f;
    }

    @Override
    public boolean hasMissingValues(int id, int markerIndex) {
        return this.alleleScores[id][markerIndex] == -128;
    }

    @Override
    public void writeData(Path filePath, FileType fileType, SubsetSolution solution, boolean includeSelected, boolean includeUnselected, boolean includeIndex) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("File path not defined.");
        }
        if (filePath.toFile().exists()) {
            throw new IOException("File already exists: " + filePath + ".");
        }
        if (fileType == null) {
            throw new IllegalArgumentException("File type not defined.");
        }
        if (fileType != FileType.TXT && fileType != FileType.CSV) {
            throw new IllegalArgumentException(String.format("Only file types TXT and CSV are supported. Got: %s.", new Object[]{fileType}));
        }
        if (solution == null) {
            throw new NullPointerException("Solution must be defined.");
        }
        if (!solution.getAllIDs().equals(this.getIDs())) {
            throw new IllegalArgumentException("Solution ids must match data.");
        }
        if (!includeSelected && !includeUnselected) {
            throw new IllegalArgumentException("At least of 'includeSelected' or 'includeUnselected' must be used.");
        }
        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        boolean markSelection = includeSelected && includeUnselected;
        try (RowWriter writer = IOUtilities.createRowWriter(filePath, fileType, 3);){
            Set<Integer> includedIDs;
            if (writer == null || !writer.ready()) {
                throw new IOException("Can not create writer for file " + filePath + ".");
            }
            if (includeIndex) {
                writer.writeCell(ID_HEADER);
                writer.newColumn();
            }
            writer.writeCell(IDENTIFIERS_HEADER);
            writer.newColumn();
            writer.writeCell(NAMES_HEADER);
            if (markSelection) {
                writer.newColumn();
                writer.writeCell(SELECTED_HEADER);
            }
            for (int m = 0; m < this.getNumberOfMarkers(); ++m) {
                writer.newColumn();
                writer.writeCell(this.getMarkerName(m));
            }
            if (markSelection) {
                includedIDs = this.getIDs();
            } else if (includeSelected) {
                includedIDs = solution.getSelectedIDs();
            } else if (includeUnselected) {
                includedIDs = solution.getUnselectedIDs();
            } else {
                throw new IllegalArgumentException("At least one of 'includeSelected' or 'includeUnselected' must be used.");
            }
            ArrayList<Integer> sortedIDs = new ArrayList<Integer>(includedIDs);
            sortedIDs.sort(null);
            Set<Integer> selected = solution.getSelectedIDs();
            Iterator iterator = sortedIDs.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                writer.newRow();
                if (includeIndex) {
                    writer.writeCell(id);
                    writer.newColumn();
                }
                SimpleEntity header = this.getHeader(id);
                writer.writeCell(header.getUniqueIdentifier());
                writer.newColumn();
                writer.writeCell(header.getName());
                if (markSelection) {
                    writer.newColumn();
                    writer.writeCell(selected.contains(id));
                }
                for (int a = 0; a < this.alleleScores[id].length; ++a) {
                    writer.newColumn();
                    byte score = this.alleleScores[id][a];
                    writer.writeCell(score == -128 ? null : Byte.valueOf(score));
                }
            }
            writer.close();
        }
    }
}

