/*
 * Decompiled with CFR 0.152.
 */
package asymmetry;

import asymmetry.CholeskyException;
import asymmetry.SYMAT;

public class Cholesky
extends SYMAT {
    private int i;
    private int j;
    private int k;
    private double sum;

    public Cholesky(int n) {
        super(n);
    }

    public Cholesky(double[][] Mat) throws CholeskyException {
        super(Mat);
        this.i = 0;
        while (this.i < this.getRowDimension()) {
            this.sum = this.getValue(this.i, this.i);
            this.k = 0;
            while (this.k <= this.i - 1) {
                this.sum -= this.getValue(this.k, this.i) * this.getValue(this.k, this.i);
                ++this.k;
            }
            if (!(this.sum > 1.0E-6)) {
                throw new CholeskyException();
            }
            this.setValue(this.i, this.i, Math.sqrt(this.sum));
            this.j = this.i + 1;
            while (this.j < this.getRowDimension()) {
                this.sum = this.getValue(this.i, this.j);
                this.k = 0;
                while (this.k <= this.i - 1) {
                    this.sum -= this.getValue(this.k, this.i) * this.getValue(this.k, this.j);
                    ++this.k;
                }
                this.setValue(this.i, this.j, this.sum / this.getValue(this.i, this.i));
                ++this.j;
            }
            ++this.i;
        }
    }

    public void toUppertriangle() throws CholeskyException {
        this.i = 0;
        while (this.i < this.getRowDimension()) {
            this.sum = this.getValue(this.i, this.i);
            this.k = 0;
            while (this.k <= this.i - 1) {
                this.sum -= this.getValue(this.k, this.i) * this.getValue(this.k, this.i);
                ++this.k;
            }
            if (!(this.sum > 1.0E-6)) {
                throw new CholeskyException();
            }
            this.setValue(this.i, this.i, Math.sqrt(this.sum));
            this.j = this.i + 1;
            while (this.j < this.getRowDimension()) {
                this.sum = this.getValue(this.i, this.j);
                this.k = 0;
                while (this.k <= this.i - 1) {
                    this.sum -= this.getValue(this.k, this.i) * this.getValue(this.k, this.j);
                    ++this.k;
                }
                this.setValue(this.i, this.j, this.sum / this.getValue(this.i, this.i));
                ++this.j;
            }
            ++this.i;
        }
    }

    public double[] solve(double[] y) {
        double[] temp2 = new double[this.rows];
        double sum = 0.0;
        temp2[0] = y[0] / this.getValue(0, 0);
        this.i = 1;
        while (this.i < this.rows) {
            sum = 0.0;
            this.j = 0;
            while (this.j < this.i) {
                sum += this.getValue(this.i, this.j) * temp2[this.j];
                ++this.j;
            }
            temp2[this.i] = (y[this.i] - sum) / this.getValue(this.i, this.i);
            ++this.i;
        }
        double[] temp = new double[this.rows];
        temp[this.rows - 1] = temp2[this.rows - 1] / this.getValue(this.rows - 1, this.rows - 1);
        this.i = this.rows - 1;
        while (this.i >= 0) {
            sum = 0.0;
            this.j = this.rows - 1;
            while (this.j >= this.i + 1) {
                sum += this.getValue(this.i, this.j) * temp[this.j];
                --this.j;
            }
            temp[this.i] = (temp2[this.i] - sum) / this.getValue(this.i, this.i);
            --this.i;
        }
        return temp;
    }

    public void setdouble(double[][] A) {
        this.i = 0;
        while (this.i < this.rows) {
            this.setValue(this.i, this.i, A[this.i][this.i]);
            this.j = this.i + 1;
            while (this.j < this.rows) {
                this.setValue(this.i, this.j, A[this.i][this.j]);
                ++this.j;
            }
            ++this.i;
        }
    }

    public double[][] getdouble() {
        double[][] tmp = new double[this.rows][this.rows];
        this.i = 0;
        while (this.i < this.rows) {
            tmp[this.i][this.i] = this.getValue(this.i, this.i);
            this.j = this.i + 1;
            while (this.j < this.rows) {
                tmp[this.i][this.j] = this.getValue(this.i, this.j);
                tmp[this.j][this.i] = this.getValue(this.i, this.j);
                ++this.j;
            }
            ++this.i;
        }
        return tmp;
    }

    public void invert() {
        SYMAT G = new SYMAT(this.B, this.rows);
        double sum = 0.0;
        this.j = this.rows - 1;
        while (this.j >= 0) {
            this.setValue(this.j, this.j, 1.0 / G.getValue(this.j, this.j));
            this.k = this.j - 1;
            while (this.k >= 0) {
                sum = 0.0;
                this.i = this.k + 1;
                while (this.i <= this.j) {
                    sum -= G.getValue(this.k, this.i) * this.getValue(this.i, this.j);
                    ++this.i;
                }
                this.setValue(this.k, this.j, sum / G.getValue(this.k, this.k));
                --this.k;
            }
            --this.j;
        }
        G = new SYMAT(this.B, this.rows);
        this.i = 0;
        while (this.i < this.rows) {
            this.j = this.i;
            while (this.j < this.rows) {
                sum = 0.0;
                this.k = this.j;
                while (this.k < this.rows) {
                    sum += G.getValue(this.i, this.k) * G.getValue(this.k, this.j);
                    ++this.k;
                }
                this.setValue(this.i, this.j, sum);
                ++this.j;
            }
            ++this.i;
        }
    }
}

