/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.rdf.model.EmptyListException;
import com.hp.hpl.jena.rdf.model.EmptyListUpdateException;
import com.hp.hpl.jena.rdf.model.InvalidListException;
import com.hp.hpl.jena.rdf.model.ListIndexException;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RDFListImpl
extends ResourceImpl
implements RDFList {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                RDFListImpl impl = new RDFListImpl(n, eg);
                if (eg instanceof OntModel) {
                    Profile prof = ((OntModel)((Object)eg)).getProfile();
                    impl.m_listFirst = prof.FIRST();
                    impl.m_listRest = prof.REST();
                    impl.m_listNil = prof.NIL();
                    impl.m_listType = prof.LIST();
                }
                return impl;
            }
            throw new JenaException("Cannot convert node " + n + " to RDFList");
        }

        public boolean canWrap(Node node, EnhGraph eg) {
            Graph g = eg.asGraph();
            Property first = RDF.first;
            Property rest = RDF.rest;
            Resource nil = RDF.nil;
            if (eg instanceof OntModel) {
                Profile prof = ((OntModel)((Object)eg)).getProfile();
                first = prof.FIRST();
                rest = prof.REST();
                nil = prof.NIL();
            }
            return node.equals(nil.asNode()) || g.find(node, first.asNode(), Node.ANY).hasNext() || g.find(node, rest.asNode(), Node.ANY).hasNext() || g.find(node, RDF.type.asNode(), RDF.List.asNode()).hasNext();
        }
    };
    protected static boolean s_checkValid = false;
    private static final Log log = LogFactory.getLog((Class)RDFListImpl.class);
    protected String m_errorMsg = null;
    protected RDFList m_tail = null;
    protected Property m_listFirst = RDF.first;
    protected Property m_listRest = RDF.rest;
    protected Resource m_listNil = RDF.nil;
    protected Resource m_listType = RDF.List;

    public RDFListImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    public Resource listType() {
        return this.m_listType;
    }

    public Resource listNil() {
        return this.m_listNil;
    }

    public Property listFirst() {
        return this.m_listFirst;
    }

    public Property listRest() {
        return this.m_listRest;
    }

    public Class listAbstractionClass() {
        return RDFList.class;
    }

    public int size() {
        if (s_checkValid) {
            this.checkValid();
        }
        int size = 0;
        ExtendedIterator i = this.iterator();
        while (i.hasNext()) {
            ++size;
            i.next();
        }
        return size;
    }

    public RDFNode getHead() {
        if (s_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to get the head of an empty list");
        return this.getRequiredProperty(this.listFirst()).getObject();
    }

    public RDFNode setHead(RDFNode value) {
        if (s_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to set the head of an empty list");
        Statement current = this.getRequiredProperty(this.listFirst());
        RDFNode n = current.getObject();
        current.remove();
        this.addProperty(this.listFirst(), value);
        return n;
    }

    public RDFList getTail() {
        if (s_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to get the tail of an empty list");
        Resource tail = this.getRequiredProperty(this.listRest()).getResource();
        return (RDFList)tail.as(this.listAbstractionClass());
    }

    public RDFList setTail(RDFList tail) {
        if (s_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to set the tail of an empty list");
        return (RDFList)RDFListImpl.setTailAux(this, tail, this.listRest()).as(this.listAbstractionClass());
    }

    public boolean isEmpty() {
        if (s_checkValid) {
            this.checkValid();
        }
        return this.equals(this.listNil());
    }

    public RDFList cons(RDFNode value) {
        if (s_checkValid) {
            this.checkValid();
        }
        return (RDFList)this.newListCell(value, this).as(this.listAbstractionClass());
    }

    public void add(RDFNode value) {
        if (s_checkValid) {
            this.checkValid();
        }
        if (this.isEmpty()) {
            throw new EmptyListUpdateException("Attempt to add() to the empty list (rdf:nil)");
        }
        RDFList tail = this.findElement(true, 0);
        RDFListImpl.setTailAux(tail, this.newListCell(value, this.listNil()), this.listRest());
    }

    public RDFList with(RDFNode value) {
        if (s_checkValid) {
            this.checkValid();
        }
        if (this.isEmpty()) {
            return this.cons(value);
        }
        RDFList tail = this.findElement(true, 0);
        RDFListImpl.setTailAux(tail, this.newListCell(value, this.listNil()), this.listRest());
        return this;
    }

    public RDFNode get(int i) {
        if (s_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to get an element from the empty list");
        return this.findElement(false, i).getHead();
    }

    public RDFNode replace(int i, RDFNode value) {
        if (s_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to replace a value in the empty list");
        return this.findElement(false, i).setHead(value);
    }

    public boolean contains(RDFNode value) {
        return this.indexOf(value, 0) >= 0;
    }

    public int indexOf(RDFNode value) {
        return this.indexOf(value, 0);
    }

    public int indexOf(RDFNode value, int start) {
        if (s_checkValid) {
            this.checkValid();
        }
        Resource l = this.findElement(false, start);
        int index = start;
        Property head = this.listFirst();
        Property tail = this.listRest();
        Resource nil = this.listNil();
        boolean found = l.hasProperty(head, value);
        while (!found && !((Object)l).equals(nil)) {
            l = l.getRequiredProperty(tail).getResource();
            ++index;
            found = l.hasProperty(head, value);
        }
        return found ? index : -1;
    }

    public RDFList append(Iterator nodes) {
        return this.append(this.copy(nodes));
    }

    public RDFList append(RDFList list) {
        if (s_checkValid) {
            this.checkValid();
        }
        if (this.isEmpty()) {
            return list;
        }
        RDFList copy = this.copy(this.iterator());
        copy.concatenate(list);
        return copy;
    }

    public void concatenate(RDFList list) {
        if (s_checkValid) {
            this.checkValid();
        }
        if (this.isEmpty()) {
            throw new EmptyListUpdateException("Tried to concatenate onto the empty list");
        }
        this.findElement(true, 0).setTail(list);
    }

    public void concatenate(Iterator nodes) {
        this.concatenate(this.copy(nodes));
    }

    public RDFList copy() {
        if (s_checkValid) {
            this.checkValid();
        }
        return this.copy(this.iterator());
    }

    public void apply(RDFList.ApplyFn fn) {
        if (s_checkValid) {
            this.checkValid();
        }
        ExtendedIterator i = this.iterator();
        while (i.hasNext()) {
            fn.apply((RDFNode)i.next());
        }
    }

    public Object reduce(RDFList.ReduceFn fn, Object initial) {
        if (s_checkValid) {
            this.checkValid();
        }
        Object acc = initial;
        ExtendedIterator i = this.iterator();
        while (i.hasNext()) {
            acc = fn.reduce((RDFNode)i.next(), acc);
        }
        return acc;
    }

    public ExtendedIterator mapWith(Map1 fn) {
        return this.iterator().mapWith(fn);
    }

    public RDFList removeHead() {
        if (s_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Attempted to delete the head of a nil list");
        RDFList tail = this.getTail();
        this.removeProperties();
        return tail;
    }

    public RDFList remove(RDFNode val) {
        if (s_checkValid) {
            this.checkValid();
        }
        RDFListImpl prev = null;
        RDFList cell = this;
        boolean searching = true;
        while (searching && !cell.isEmpty()) {
            if (cell.getHead().equals(val)) {
                RDFList tail = cell.getTail();
                if (prev != null) {
                    prev.setTail(tail);
                }
                cell.removeProperties();
                return prev == null ? tail : this;
            }
            prev = cell;
            cell = cell.getTail();
        }
        return this;
    }

    public void removeAll() {
        this.removeList();
    }

    public void removeList() {
        Iterator i = this.collectStatements().iterator();
        while (i.hasNext()) {
            ((Statement)i.next()).remove();
        }
    }

    public Set collectStatements() {
        HashSet stmts = new HashSet();
        RDFList l = this;
        do {
            StmtIterator i = l.listProperties();
            while (i.hasNext()) {
                stmts.add(i.next());
            }
        } while (!(l = l.getTail()).isEmpty());
        return stmts;
    }

    public ExtendedIterator iterator() {
        return new RDFListIterator(this);
    }

    public List asJavaList() {
        ArrayList l = new ArrayList();
        ExtendedIterator i = this.iterator();
        while (i.hasNext()) {
            l.add(i.next());
        }
        return l;
    }

    public boolean sameListAs(RDFList list) {
        if (s_checkValid) {
            this.checkValid();
        }
        Resource r0 = this;
        Resource r1 = list;
        Property head = this.listFirst();
        Property tail = this.listRest();
        Resource nil = this.listNil();
        while (!((Object)r0).equals(nil) && !r1.equals(nil)) {
            RDFNode n0 = r0.getRequiredProperty(head).getObject();
            RDFNode n1 = r1.getRequiredProperty(head).getObject();
            if (n0 == null || !n0.equals(n1)) {
                return false;
            }
            r0 = r0.getRequiredProperty(tail).getResource();
            r1 = r1.getRequiredProperty(tail).getResource();
        }
        return ((Object)r0).equals(nil) && r1.equals(nil);
    }

    public boolean getStrict() {
        return s_checkValid;
    }

    public void setStrict(boolean strict) {
        s_checkValid = strict;
    }

    public boolean isValid() {
        this.m_errorMsg = null;
        try {
            this.checkValid();
        }
        catch (InvalidListException e) {
            this.m_errorMsg = e.getMessage();
        }
        return this.m_errorMsg == null;
    }

    public String getValidityErrorMessage() {
        return this.m_errorMsg;
    }

    public Resource newListCell(RDFNode value, Resource tail) {
        Resource cell = this.getModel().createResource();
        cell.addProperty(this.listFirst(), value);
        cell.addProperty(this.listRest(), tail);
        return cell;
    }

    protected void checkValid() {
        if (!this.equals(this.listNil())) {
            this.checkValidProperty(this.listFirst(), null);
            this.checkValidProperty(this.listRest(), null);
        }
    }

    private void checkValidProperty(Property p, RDFNode expected) {
        int count = 0;
        StmtIterator j = this.getModel().listStatements((Resource)this, p, expected);
        while (j.hasNext()) {
            ++count;
            j.next();
        }
        if (count == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed validity check on " + this.toString()));
                StmtIterator i = this.listProperties();
                while (i.hasNext()) {
                    log.debug((Object)("  this => " + i.next()));
                }
                i = this.getModel().listStatements(null, null, this);
                while (i.hasNext()) {
                    log.debug((Object)("  => this " + i.next()));
                }
            }
            throw new InvalidListException("List node " + this.toString() + " is not valid: it should have property " + p.toString() + (expected == null ? "" : " with value " + expected));
        }
        if (count > 1) {
            throw new InvalidListException("List node " + this.toString() + " is not valid: it has more than one value for " + p.toString());
        }
    }

    protected void checkNotNil(String msg) {
        if (this.isEmpty()) {
            throw new EmptyListException(msg);
        }
    }

    protected RDFList findElement(boolean last, int index) {
        boolean found;
        Property tail = this.listRest();
        Resource nil = this.listNil();
        Resource l = this;
        int i = index;
        boolean bl = found = last && l.hasProperty(tail, nil) || !last && i == 0;
        while (!found && !((Object)l).equals(nil)) {
            l = l.getRequiredProperty(tail).getResource();
            found = last && l.hasProperty(tail, nil) || !last && --i == 0;
        }
        if (!found) {
            if (!last) {
                throw new ListIndexException("Tried to access element " + index + " that is beyond the length of the list");
            }
            throw new InvalidListException("Could not find last element of list (suggests list is not valid)");
        }
        return (RDFList)l.as(this.listAbstractionClass());
    }

    protected RDFList copy(Iterator i) {
        Resource list = null;
        RDFNode start = null;
        Property head = this.listFirst();
        Property tail = this.listRest();
        Resource cellType = this.listType();
        while (i.hasNext()) {
            Resource cell = this.getModel().createResource(cellType);
            cell.addProperty(head, (RDFNode)i.next());
            if (list != null) {
                list.addProperty(tail, cell);
            } else {
                start = cell;
            }
            list = cell;
        }
        list.addProperty(tail, this.listNil());
        return (RDFList)start.as(this.listAbstractionClass());
    }

    protected static Resource setTailAux(Resource root, Resource tail, Property pTail) {
        Statement current = root.getRequiredProperty(pTail);
        Resource oldTail = current.getResource();
        current.remove();
        root.addProperty(pTail, tail);
        return oldTail;
    }

    protected class RDFListIterator
    extends NiceIterator {
        protected RDFList m_head;
        protected RDFList m_seen = null;

        protected RDFListIterator(RDFList head) {
            this.m_head = head;
        }

        public boolean hasNext() {
            return !this.m_head.isEmpty();
        }

        public Object next() {
            this.m_seen = this.m_head;
            this.m_head = this.m_head.getTail();
            return this.m_seen.getHead();
        }

        public void remove() {
            if (this.m_seen == null) {
                throw new IllegalStateException("Illegal remove from list operator");
            }
            this.m_seen.removeProperties();
            this.m_seen = null;
        }
    }
}

