/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

import java.util.ArrayList;
import java.util.List;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.SVar;
import org.rosuda.util.Global;
import org.rosuda.util.ProgressDlg;
import org.rosuda.util.Stopwatch;

public class SVarFixDouble
extends SVar {
    double[] cont;
    int insertPos = 0;
    List cats;
    List ccnts;
    int[] ranks = null;

    public SVarFixDouble(String Name, int len) {
        super(Name, false);
        if (len < 0) {
            len = 0;
        }
        this.guessing = false;
        this.contentsType = 1;
        this.isnum = true;
        this.cont = new double[len];
    }

    public SVarFixDouble(String Name, double[] d) {
        this(Name, d, true);
    }

    public SVarFixDouble(String Name, double[] d, boolean copyContents) {
        super(Name, false);
        boolean firstValid = true;
        this.max = 0.0;
        this.min = 0.0;
        if (copyContents) {
            this.cont = new double[d.length];
            for (int i = 0; i < d.length; ++i) {
                this.cont[i] = d[i];
                if (Double.isNaN(this.cont[i])) {
                    ++this.missingCount;
                    continue;
                }
                if (firstValid) {
                    this.min = this.max = this.cont[i];
                    firstValid = false;
                    continue;
                }
                if (this.cont[i] > this.max) {
                    this.max = this.cont[i];
                    continue;
                }
                if (!(this.cont[i] < this.min)) continue;
                this.min = this.cont[i];
            }
        } else {
            this.cont = d;
            for (int i = 0; i < d.length; ++i) {
                if (Double.isNaN(this.cont[i])) {
                    ++this.missingCount;
                    continue;
                }
                if (firstValid) {
                    this.min = this.max = this.cont[i];
                    firstValid = false;
                    continue;
                }
                if (this.cont[i] > this.max) {
                    this.max = this.cont[i];
                    continue;
                }
                if (!(this.cont[i] < this.min)) continue;
                this.min = this.cont[i];
            }
        }
        this.insertPos = d.length;
        this.guessing = false;
        this.contentsType = 1;
        this.isnum = true;
    }

    public int size() {
        return this.cont.length;
    }

    public void categorize(boolean rebuild) {
        if (this.cat && !rebuild) {
            return;
        }
        this.cats = new ArrayList();
        this.ccnts = new ArrayList();
        this.cat = true;
        if (!this.isEmpty()) {
            int ci = 0;
            while (ci < this.cont.length) {
                String oo = Double.isNaN(this.cont[ci]) ? "NA" : Double.toString(this.cont[ci]);
                int i = this.cats.indexOf(oo);
                if (i == -1) {
                    this.cats.add(oo);
                    this.ccnts.add(new Integer(1));
                    continue;
                }
                this.ccnts.set(i, new Integer((Integer)this.ccnts.get(i) + 1));
            }
            if (this.isNum()) {
                this.sortCategories(1);
            }
        }
        this.NotifyAll(new NotifyMsg(this, 12290));
    }

    public void sortCategories(int method) {
        if (!this.isCat() || this.cats.size() < 2) {
            return;
        }
        Stopwatch sw = null;
        if (Global.DEBUG > 0) {
            sw = new Stopwatch();
            System.out.println("Sorting variable \"" + this.name + "\"");
        }
        List ocats = this.cats;
        List occnts = this.ccnts;
        this.cats = new ArrayList(ocats.size());
        this.ccnts = new ArrayList(occnts.size());
        boolean found = true;
        int cs = ocats.size();
        while (found) {
            found = false;
            int p = -1;
            double min = -0.01;
            boolean gotmin = false;
            String mino = null;
            for (int i = 0; i < cs; ++i) {
                Object o = ocats.get(i);
                if (o == null) continue;
                if (method == 1) {
                    double val = -0.01;
                    try {
                        val = ((Number)o).doubleValue();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!gotmin) {
                        gotmin = true;
                        min = val;
                        p = i;
                        continue;
                    }
                    if (!(val < min)) continue;
                    min = val;
                    p = i;
                    continue;
                }
                if (!gotmin) {
                    gotmin = true;
                    mino = o.toString();
                    p = i;
                    continue;
                }
                if (mino.compareTo(o.toString()) <= 0) continue;
                mino = o.toString();
                p = i;
            }
            found = gotmin;
            if (!found) continue;
            this.cats.add(ocats.get(p));
            this.ccnts.add(occnts.get(p));
            ocats.set(p, null);
        }
        if (Global.DEBUG > 0) {
            sw.profile("sorted");
        }
    }

    public void dropCat() {
        this.cats = null;
        this.ccnts = null;
        this.cat = false;
        this.NotifyAll(new NotifyMsg(this, 12290));
    }

    public void setCategorical(boolean nc) {
        if (!nc) {
            this.cat = false;
        } else if (this.cats == null) {
            this.categorize();
        } else {
            this.cat = true;
        }
    }

    public boolean add(Object o) {
        if (this.insertPos >= this.cont.length) {
            return false;
        }
        if (this.cacheRanks && this.ranks != null) {
            this.ranks = null;
        }
        double val = double_NA;
        if (o != null) {
            try {
                val = Double.parseDouble(o.toString());
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return this.add(val);
    }

    public boolean add(int i) {
        return this.add(i == int_NA ? double_NA : (double)i);
    }

    public boolean add(double d) {
        if (this.insertPos >= this.cont.length) {
            return false;
        }
        if (this.cat) {
            String oo = Double.isNaN(d) ? "NA" : Double.toString(d);
            int i = this.cats.indexOf(oo);
            if (i == -1) {
                this.cats.add(oo);
                this.ccnts.add(new Integer(1));
            } else {
                this.ccnts.set(i, new Integer((Integer)this.ccnts.get(i) + 1));
            }
        }
        if (!Double.isNaN(d)) {
            if (d > this.max) {
                this.max = d;
            }
            if (d < this.min) {
                this.min = d;
            }
        } else {
            ++this.missingCount;
        }
        this.cont[this.insertPos++] = d;
        this.NotifyAll(new NotifyMsg(this, 12289));
        return true;
    }

    public boolean replace(int i, Object o) {
        return false;
    }

    public boolean replace(int i, double d) {
        if (i < 0 || i >= this.cont.length || this.isCat()) {
            return false;
        }
        if (Double.isNaN(this.cont[i])) {
            --this.missingCount;
        }
        this.cont[i] = d;
        if (Double.isNaN(d)) {
            ++this.missingCount;
        }
        return true;
    }

    public Object at(int i) {
        return i < 0 || i >= this.insertPos || SVarFixDouble.isNA(this.cont[i]) ? null : new Double(this.cont[i]);
    }

    public double atD(int i) {
        return i < 0 || i >= this.insertPos ? double_NA : this.cont[i];
    }

    public int atI(int i) {
        return i < 0 || i >= this.insertPos || Double.isNaN(this.cont[i]) ? int_NA : (int)(this.cont[i] + 0.5);
    }

    public String asS(int i) {
        return i < 0 || i >= this.insertPos || SVarFixDouble.isNA(this.cont[i]) ? null : Double.toString(this.cont[i]);
    }

    public int getCatIndex(Object o) {
        if (this.cats == null) {
            return -1;
        }
        Object oo = o;
        if (o == null) {
            oo = "NA";
        }
        return this.cats.indexOf(oo);
    }

    public int getCatIndex(int i) {
        try {
            return this.getCatIndex(this.elementAt(i));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public Object getCatAt(int i) {
        if (this.cats == null) {
            return null;
        }
        try {
            return this.cats.get(i);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getSizeCatAt(int i) {
        if (this.cats == null) {
            return -1;
        }
        try {
            return (Integer)this.ccnts.get(i);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int getSizeCat(Object o) {
        if (this.cats == null) {
            return -1;
        }
        int i = this.cats.indexOf(o);
        return i == 1 ? -1 : (Integer)this.ccnts.get(i);
    }

    public int getNumCats() {
        if (this.cats == null) {
            return 0;
        }
        return this.cats.size();
    }

    public Object[] getCategories() {
        if (this.cats == null) {
            return null;
        }
        Object[] c = new Object[this.cats.size()];
        this.cats.toArray(c);
        return c;
    }

    public boolean remove(int index) {
        return false;
    }

    public boolean insert(Object o, int index) {
        return false;
    }

    public int[] getRanked(SMarker m, int markspec) {
        int ct;
        Stopwatch sw = new Stopwatch();
        if (this.isCat() || !this.isNum() || this.size() == 0) {
            return null;
        }
        if (m == null && this.cacheRanks && this.ranks != null) {
            return this.ranks;
        }
        int[] r = null;
        if (!this.cacheRanks || this.ranks == null) {
            int i;
            ProgressDlg pd = null;
            if (this.size() > 1000) {
                pd = new ProgressDlg("Variable " + this.getName());
                pd.begin("Calculating ranks ...");
            }
            ct = this.size();
            r = new int[ct];
            double[] da = this.cont;
            sw.profile("getRanked: pass 1: store relevant values");
            for (i = 0; i < ct; ++i) {
                r[i] = i;
            }
            for (i = 0; i < ct - 1; ++i) {
                double d = da[r[i]];
                int j = ct - 1;
                if (pd != null && (i & 0xFF) == 0) {
                    pd.setProgress((int)((double)i * 99.0 / (double)ct));
                }
                while (j > i) {
                    double d2 = da[r[j]];
                    if (d2 < d) {
                        int xx = r[i];
                        r[i] = r[j];
                        r[j] = xx;
                        d = d2;
                    }
                    --j;
                }
            }
            if (pd != null) {
                pd.setProgress(99);
            }
            sw.profile("getRanked: pass 2: sort");
            if (this.cacheRanks) {
                this.ranks = r;
            }
            da = null;
            if (pd != null) {
                pd.end();
            }
            pd = null;
        } else {
            r = this.ranks;
        }
        if (m != null && r != null) {
            int i;
            int x = r.length;
            ct = 0;
            for (i = 0; i < x; ++i) {
                if (m.get(i) != markspec) continue;
                ++ct;
            }
            if (ct == 0) {
                return null;
            }
            int[] mr = new int[ct];
            int mri = 0;
            for (i = 0; i < x; ++i) {
                if (m.get(r[i]) != markspec) continue;
                mr[mri++] = r[i];
            }
            r = null;
            r = mr;
        }
        return r;
    }

    public String toString() {
        return "SVarFixDouble(\"" + this.name + "\"," + (this.cat ? "cat," : "cont,") + (this.isnum ? "num," : "txt,") + "n=" + this.size() + "/" + this.cont.length + ",miss=" + this.missingCount + ")";
    }
}

