/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.rosuda.JGR.JGR;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.REngineException;

public class RUtils {
    public static REngine R_ENGINE = JGR.getREngine();

    public static String[] ls() throws REngineException, REXPMismatchException {
        if (R_ENGINE == null) {
            return null;
        }
        String cmd = "ls()";
        REXP exp = R_ENGINE.parseAndEval(cmd);
        if (exp != null) {
            return exp.asStrings();
        }
        return null;
    }

    public static Object[] ls(String rClass) throws REngineException, REXPMismatchException {
        if (R_ENGINE == null) {
            return null;
        }
        ArrayList<String> vars = new ArrayList<String>();
        for (String var : RUtils.ls()) {
            String cmd = "class(" + var + ")";
            REXP exp = R_ENGINE.parseAndEval(cmd);
            if (exp == null || exp.isNull()) continue;
            String varClass = null;
            if (exp.isString()) {
                varClass = exp.asString();
            }
            if (varClass == null || varClass.compareTo(rClass) != 0) continue;
            vars.add(var);
        }
        return vars.toArray();
    }

    public static Object[] getDatasetList() throws REngineException, REXPMismatchException {
        return RUtils.ls("data.frame");
    }

    public static String[] colnames(String x) throws REngineException, REXPMismatchException {
        if (R_ENGINE == null) {
            return null;
        }
        String cmd = "colnames(" + x + ")";
        REXP exp = R_ENGINE.parseAndEval(cmd);
        if (exp != null) {
            return exp.asStrings();
        }
        return null;
    }

    public static Vector colnamesVector(String x) throws REngineException, REXPMismatchException {
        String[] cols = RUtils.colnames(x);
        Vector<String> colvec = new Vector<String>(cols.length);
        int n = cols.length;
        for (int i = 0; i < n; ++i) {
            colvec.add(cols[i]);
        }
        return colvec;
    }

    public static Vector factors(String x) throws REngineException, REXPMismatchException {
        String[] cols = RUtils.colnames(x);
        if (cols != null) {
            Vector<String> factors = new Vector<String>(cols.length);
            for (String col : cols) {
                boolean isFactor;
                String var = x + "$" + col;
                String cmd = "as.character(is.factor(" + var + ") | is.logical(" + var + ") | is.character(" + var + "))";
                REXP exp = R_ENGINE.parseAndEval(cmd);
                if (exp == null || !(isFactor = Boolean.valueOf(exp.asString()).booleanValue())) continue;
                factors.add(col);
            }
            return factors;
        }
        return null;
    }

    public static Vector nonFactors(String x) throws REngineException, REXPMismatchException {
        String[] cols = RUtils.colnames(x);
        if (cols != null) {
            Vector<String> nonFactors = new Vector<String>(cols.length);
            for (String col : cols) {
                String var = x + "$" + col;
                String cmd = "as.character(is.factor(" + var + ") | is.logical(" + var + ") | is.character(" + var + "))";
                boolean isFactor = Boolean.valueOf(R_ENGINE.parseAndEval(cmd).asString());
                if (isFactor) continue;
                nonFactors.add(col);
            }
            return nonFactors;
        }
        return null;
    }

    public static Vector colnamesNumericVector(String x) throws REngineException, REXPMismatchException {
        String[] cols = RUtils.colnames(x);
        if (cols != null) {
            Vector<String> numerics = new Vector<String>(cols.length);
            for (String col : cols) {
                boolean isNumeric;
                String var = x + "$" + col;
                String cmd = "is.numeric(" + var + ")";
                REXP exp = R_ENGINE.parseAndEval(cmd);
                if (exp == null || !(isNumeric = Boolean.valueOf(exp.asString()).booleanValue())) continue;
                numerics.add(col);
            }
            return numerics;
        }
        return null;
    }

    public static String toString(Object[] obj, String separator, String quote) {
        if (obj != null) {
            return RUtils.toString(Arrays.asList(obj), separator, quote);
        }
        return "";
    }

    public static String toString(List list, String separator, String quote) {
        String str = "";
        if (separator == null) {
            separator = ",";
        }
        if (quote == null) {
            quote = "'";
        }
        if (list != null && list.size() > 0) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Object o = list.get(i);
                if (o == null) continue;
                str = o instanceof Integer || o instanceof Double ? str + o + separator : str + quote + o + quote + separator;
            }
            if (str.length() >= separator.length()) {
                str = str.substring(0, str.length() - separator.length());
            }
        }
        return str;
    }

    public static String getStringValue(String val) {
        val = val != null ? "'" + val + "'" : "NULL";
        return val;
    }

    public static String getBooleanValue(Boolean val) {
        if (val != null && val.booleanValue()) {
            return "T";
        }
        return "F";
    }

    public static Vector evalAsVector(String cmd) throws REngineException, REXPMismatchException {
        if (R_ENGINE == null) {
            return null;
        }
        String cmd2 = "as.vector(" + cmd + ")";
        REXP exp = R_ENGINE.parseAndEval(cmd2);
        if (exp != null && !exp.isNull()) {
            Vector<Object> v;
            if (exp.isInteger() && exp.isVector()) {
                int[] intArray = exp.asIntegers();
                v = new Vector<Object>(intArray.length);
                int n = intArray.length;
                for (int i = 0; i < n; ++i) {
                    v.add(new Integer(intArray[i]));
                }
            } else if (exp.isNumeric() && exp.isVector()) {
                double[] dblArray = exp.asDoubles();
                v = new Vector(dblArray.length);
                int n = dblArray.length;
                for (int i = 0; i < n; ++i) {
                    v.add(new Double(dblArray[i]));
                }
            } else if (exp.isString() && exp.isVector()) {
                String[] strArray = exp.asStrings();
                v = new Vector(strArray.length);
                int n = strArray.length;
                for (int i = 0; i < n; ++i) {
                    v.add(strArray[i]);
                }
            } else if (exp.isString()) {
                String str = exp.asString();
                v = new Vector(1);
                v.add(str);
            } else {
                cmd2 = "as.character(" + cmd + ")";
                String[] strArray = R_ENGINE.parseAndEval(cmd2).asStrings();
                v = new Vector(strArray.length);
                int n = strArray.length;
                for (int i = 0; i < n; ++i) {
                    v.add(strArray[i]);
                }
            }
            return v;
        }
        return null;
    }

    public static String evalAsString(String cmd) throws REngineException, REXPMismatchException {
        String str = null;
        if (R_ENGINE == null) {
            return str;
        }
        REXP exp = R_ENGINE.parseAndEval(cmd);
        if (exp != null && !exp.isNull() && exp.isString()) {
            str = exp.asString();
        }
        return str;
    }
}

