/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.waf.model.IPSetUpdate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateIPSetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String iPSetId;
    private String changeToken;
    private List<IPSetUpdate> updates;

    public void setIPSetId(String iPSetId) {
        this.iPSetId = iPSetId;
    }

    public String getIPSetId() {
        return this.iPSetId;
    }

    public UpdateIPSetRequest withIPSetId(String iPSetId) {
        this.setIPSetId(iPSetId);
        return this;
    }

    public void setChangeToken(String changeToken) {
        this.changeToken = changeToken;
    }

    public String getChangeToken() {
        return this.changeToken;
    }

    public UpdateIPSetRequest withChangeToken(String changeToken) {
        this.setChangeToken(changeToken);
        return this;
    }

    public List<IPSetUpdate> getUpdates() {
        return this.updates;
    }

    public void setUpdates(Collection<IPSetUpdate> updates) {
        if (updates == null) {
            this.updates = null;
            return;
        }
        this.updates = new ArrayList<IPSetUpdate>(updates);
    }

    public UpdateIPSetRequest withUpdates(IPSetUpdate ... updates) {
        if (this.updates == null) {
            this.setUpdates(new ArrayList<IPSetUpdate>(updates.length));
        }
        for (IPSetUpdate ele : updates) {
            this.updates.add(ele);
        }
        return this;
    }

    public UpdateIPSetRequest withUpdates(Collection<IPSetUpdate> updates) {
        this.setUpdates(updates);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIPSetId() != null) {
            sb.append("IPSetId: ").append(this.getIPSetId()).append(",");
        }
        if (this.getChangeToken() != null) {
            sb.append("ChangeToken: ").append(this.getChangeToken()).append(",");
        }
        if (this.getUpdates() != null) {
            sb.append("Updates: ").append(this.getUpdates());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIPSetRequest)) {
            return false;
        }
        UpdateIPSetRequest other = (UpdateIPSetRequest)obj;
        if (other.getIPSetId() == null ^ this.getIPSetId() == null) {
            return false;
        }
        if (other.getIPSetId() != null && !other.getIPSetId().equals(this.getIPSetId())) {
            return false;
        }
        if (other.getChangeToken() == null ^ this.getChangeToken() == null) {
            return false;
        }
        if (other.getChangeToken() != null && !other.getChangeToken().equals(this.getChangeToken())) {
            return false;
        }
        if (other.getUpdates() == null ^ this.getUpdates() == null) {
            return false;
        }
        return other.getUpdates() == null || other.getUpdates().equals(this.getUpdates());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIPSetId() == null ? 0 : this.getIPSetId().hashCode());
        hashCode = 31 * hashCode + (this.getChangeToken() == null ? 0 : this.getChangeToken().hashCode());
        hashCode = 31 * hashCode + (this.getUpdates() == null ? 0 : this.getUpdates().hashCode());
        return hashCode;
    }

    public UpdateIPSetRequest clone() {
        return (UpdateIPSetRequest)super.clone();
    }
}

