/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.identitymanagement.model.CreatePolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreatePolicyRequestMarshaller
implements Marshaller<Request<CreatePolicyRequest>, CreatePolicyRequest> {
    public Request<CreatePolicyRequest> marshall(CreatePolicyRequest createPolicyRequest) {
        if (createPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPolicyRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "CreatePolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createPolicyRequest.getPolicyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString((String)createPolicyRequest.getPolicyName()));
        }
        if (createPolicyRequest.getPath() != null) {
            request.addParameter("Path", StringUtils.fromString((String)createPolicyRequest.getPath()));
        }
        if (createPolicyRequest.getPolicyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString((String)createPolicyRequest.getPolicyDocument()));
        }
        if (createPolicyRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createPolicyRequest.getDescription()));
        }
        return request;
    }
}

