/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simplesystemsmanagement.model.AutomationExecutionStatus;
import com.amazonaws.services.simplesystemsmanagement.model.StepExecution;
import com.amazonaws.services.simplesystemsmanagement.model.transform.AutomationExecutionMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AutomationExecution
implements Serializable,
Cloneable,
StructuredPojo {
    private String automationExecutionId;
    private String documentName;
    private String documentVersion;
    private Date executionStartTime;
    private Date executionEndTime;
    private String automationExecutionStatus;
    private SdkInternalList<StepExecution> stepExecutions;
    private Map<String, List<String>> parameters;
    private Map<String, List<String>> outputs;
    private String failureMessage;

    public void setAutomationExecutionId(String automationExecutionId) {
        this.automationExecutionId = automationExecutionId;
    }

    public String getAutomationExecutionId() {
        return this.automationExecutionId;
    }

    public AutomationExecution withAutomationExecutionId(String automationExecutionId) {
        this.setAutomationExecutionId(automationExecutionId);
        return this;
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public AutomationExecution withDocumentName(String documentName) {
        this.setDocumentName(documentName);
        return this;
    }

    public void setDocumentVersion(String documentVersion) {
        this.documentVersion = documentVersion;
    }

    public String getDocumentVersion() {
        return this.documentVersion;
    }

    public AutomationExecution withDocumentVersion(String documentVersion) {
        this.setDocumentVersion(documentVersion);
        return this;
    }

    public void setExecutionStartTime(Date executionStartTime) {
        this.executionStartTime = executionStartTime;
    }

    public Date getExecutionStartTime() {
        return this.executionStartTime;
    }

    public AutomationExecution withExecutionStartTime(Date executionStartTime) {
        this.setExecutionStartTime(executionStartTime);
        return this;
    }

    public void setExecutionEndTime(Date executionEndTime) {
        this.executionEndTime = executionEndTime;
    }

    public Date getExecutionEndTime() {
        return this.executionEndTime;
    }

    public AutomationExecution withExecutionEndTime(Date executionEndTime) {
        this.setExecutionEndTime(executionEndTime);
        return this;
    }

    public void setAutomationExecutionStatus(String automationExecutionStatus) {
        this.automationExecutionStatus = automationExecutionStatus;
    }

    public String getAutomationExecutionStatus() {
        return this.automationExecutionStatus;
    }

    public AutomationExecution withAutomationExecutionStatus(String automationExecutionStatus) {
        this.setAutomationExecutionStatus(automationExecutionStatus);
        return this;
    }

    public void setAutomationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
        this.withAutomationExecutionStatus(automationExecutionStatus);
    }

    public AutomationExecution withAutomationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
        this.automationExecutionStatus = automationExecutionStatus.toString();
        return this;
    }

    public List<StepExecution> getStepExecutions() {
        if (this.stepExecutions == null) {
            this.stepExecutions = new SdkInternalList();
        }
        return this.stepExecutions;
    }

    public void setStepExecutions(Collection<StepExecution> stepExecutions) {
        if (stepExecutions == null) {
            this.stepExecutions = null;
            return;
        }
        this.stepExecutions = new SdkInternalList(stepExecutions);
    }

    public AutomationExecution withStepExecutions(StepExecution ... stepExecutions) {
        if (this.stepExecutions == null) {
            this.setStepExecutions((Collection<StepExecution>)new SdkInternalList(stepExecutions.length));
        }
        for (StepExecution ele : stepExecutions) {
            this.stepExecutions.add((Object)ele);
        }
        return this;
    }

    public AutomationExecution withStepExecutions(Collection<StepExecution> stepExecutions) {
        this.setStepExecutions(stepExecutions);
        return this;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, List<String>> parameters) {
        this.parameters = parameters;
    }

    public AutomationExecution withParameters(Map<String, List<String>> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public AutomationExecution addParametersEntry(String key, List<String> value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, List<String>>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public AutomationExecution clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public Map<String, List<String>> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Map<String, List<String>> outputs) {
        this.outputs = outputs;
    }

    public AutomationExecution withOutputs(Map<String, List<String>> outputs) {
        this.setOutputs(outputs);
        return this;
    }

    public AutomationExecution addOutputsEntry(String key, List<String> value) {
        if (null == this.outputs) {
            this.outputs = new HashMap<String, List<String>>();
        }
        if (this.outputs.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.outputs.put(key, value);
        return this;
    }

    public AutomationExecution clearOutputsEntries() {
        this.outputs = null;
        return this;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public AutomationExecution withFailureMessage(String failureMessage) {
        this.setFailureMessage(failureMessage);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAutomationExecutionId() != null) {
            sb.append("AutomationExecutionId: ").append(this.getAutomationExecutionId()).append(",");
        }
        if (this.getDocumentName() != null) {
            sb.append("DocumentName: ").append(this.getDocumentName()).append(",");
        }
        if (this.getDocumentVersion() != null) {
            sb.append("DocumentVersion: ").append(this.getDocumentVersion()).append(",");
        }
        if (this.getExecutionStartTime() != null) {
            sb.append("ExecutionStartTime: ").append(this.getExecutionStartTime()).append(",");
        }
        if (this.getExecutionEndTime() != null) {
            sb.append("ExecutionEndTime: ").append(this.getExecutionEndTime()).append(",");
        }
        if (this.getAutomationExecutionStatus() != null) {
            sb.append("AutomationExecutionStatus: ").append(this.getAutomationExecutionStatus()).append(",");
        }
        if (this.getStepExecutions() != null) {
            sb.append("StepExecutions: ").append(this.getStepExecutions()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: ").append(this.getOutputs()).append(",");
        }
        if (this.getFailureMessage() != null) {
            sb.append("FailureMessage: ").append(this.getFailureMessage());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationExecution)) {
            return false;
        }
        AutomationExecution other = (AutomationExecution)obj;
        if (other.getAutomationExecutionId() == null ^ this.getAutomationExecutionId() == null) {
            return false;
        }
        if (other.getAutomationExecutionId() != null && !other.getAutomationExecutionId().equals(this.getAutomationExecutionId())) {
            return false;
        }
        if (other.getDocumentName() == null ^ this.getDocumentName() == null) {
            return false;
        }
        if (other.getDocumentName() != null && !other.getDocumentName().equals(this.getDocumentName())) {
            return false;
        }
        if (other.getDocumentVersion() == null ^ this.getDocumentVersion() == null) {
            return false;
        }
        if (other.getDocumentVersion() != null && !other.getDocumentVersion().equals(this.getDocumentVersion())) {
            return false;
        }
        if (other.getExecutionStartTime() == null ^ this.getExecutionStartTime() == null) {
            return false;
        }
        if (other.getExecutionStartTime() != null && !other.getExecutionStartTime().equals(this.getExecutionStartTime())) {
            return false;
        }
        if (other.getExecutionEndTime() == null ^ this.getExecutionEndTime() == null) {
            return false;
        }
        if (other.getExecutionEndTime() != null && !other.getExecutionEndTime().equals(this.getExecutionEndTime())) {
            return false;
        }
        if (other.getAutomationExecutionStatus() == null ^ this.getAutomationExecutionStatus() == null) {
            return false;
        }
        if (other.getAutomationExecutionStatus() != null && !other.getAutomationExecutionStatus().equals(this.getAutomationExecutionStatus())) {
            return false;
        }
        if (other.getStepExecutions() == null ^ this.getStepExecutions() == null) {
            return false;
        }
        if (other.getStepExecutions() != null && !other.getStepExecutions().equals(this.getStepExecutions())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        if (other.getOutputs() != null && !other.getOutputs().equals(this.getOutputs())) {
            return false;
        }
        if (other.getFailureMessage() == null ^ this.getFailureMessage() == null) {
            return false;
        }
        return other.getFailureMessage() == null || other.getFailureMessage().equals(this.getFailureMessage());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutomationExecutionId() == null ? 0 : this.getAutomationExecutionId().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentName() == null ? 0 : this.getDocumentName().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentVersion() == null ? 0 : this.getDocumentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionStartTime() == null ? 0 : this.getExecutionStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionEndTime() == null ? 0 : this.getExecutionEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getAutomationExecutionStatus() == null ? 0 : this.getAutomationExecutionStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStepExecutions() == null ? 0 : this.getStepExecutions().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        hashCode = 31 * hashCode + (this.getFailureMessage() == null ? 0 : this.getFailureMessage().hashCode());
        return hashCode;
    }

    public AutomationExecution clone() {
        try {
            return (AutomationExecution)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutomationExecutionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

