/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.ConversionException;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.converters.BigDecimalConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.converters.BigIntegerConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.converters.BooleanConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.converters.ByteConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.converters.CharacterConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.converters.DoubleConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.converters.FloatConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.converters.IntegerConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.converters.LongConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.converters.ShortConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.locale.converters.BigDecimalLocaleConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.locale.converters.BigIntegerLocaleConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.locale.converters.ByteLocaleConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.locale.converters.DoubleLocaleConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.locale.converters.FloatLocaleConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.locale.converters.IntegerLocaleConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.locale.converters.LongLocaleConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.locale.converters.ShortLocaleConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.lang3.StringUtils;
import com.opencsv.bean.AbstractBeanField;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;

public class BeanFieldPrimitiveTypes<T>
extends AbstractBeanField<T> {
    private final boolean required;
    private final String locale;

    public BeanFieldPrimitiveTypes(Field field, boolean required, String locale) {
        super(field);
        this.required = required;
        this.locale = locale;
    }

    public boolean isRequired() {
        return this.required;
    }

    @Override
    protected Object convert(String value) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException {
        Object o;
        block31: {
            if (this.required && StringUtils.isBlank(value)) {
                throw new CsvRequiredFieldEmptyException(String.format("Field '%s' is mandatory but no value was provided.", this.field.getName()));
            }
            o = null;
            if (StringUtils.isNotBlank(value)) {
                Class<String> fieldType = this.field.getType();
                try {
                    if (fieldType.equals(Boolean.TYPE) || fieldType.equals(Boolean.class)) {
                        BooleanConverter c = new BooleanConverter();
                        o = c.convert(Boolean.class, value.trim());
                        break block31;
                    }
                    if (fieldType.equals(Byte.TYPE) || fieldType.equals(Byte.class)) {
                        if (StringUtils.isEmpty(this.locale)) {
                            ByteConverter c = new ByteConverter();
                            o = c.convert(Byte.class, value.trim());
                        } else {
                            ByteLocaleConverter c = new ByteLocaleConverter(Locale.forLanguageTag(this.locale));
                            o = c.convert(value.trim());
                        }
                        break block31;
                    }
                    if (fieldType.equals(Double.TYPE) || fieldType.equals(Double.class)) {
                        if (StringUtils.isEmpty(this.locale)) {
                            DoubleConverter c = new DoubleConverter();
                            o = c.convert(Double.class, value.trim());
                        } else {
                            DoubleLocaleConverter c = new DoubleLocaleConverter(Locale.forLanguageTag(this.locale));
                            o = c.convert(value.trim());
                        }
                        break block31;
                    }
                    if (fieldType.equals(Float.TYPE) || fieldType.equals(Float.class)) {
                        if (StringUtils.isEmpty(this.locale)) {
                            FloatConverter c = new FloatConverter();
                            o = c.convert(Float.class, value.trim());
                        } else {
                            FloatLocaleConverter c = new FloatLocaleConverter(Locale.forLanguageTag(this.locale));
                            o = c.convert(value.trim());
                        }
                        break block31;
                    }
                    if (fieldType.equals(Integer.TYPE) || fieldType.equals(Integer.class)) {
                        if (StringUtils.isEmpty(this.locale)) {
                            IntegerConverter c = new IntegerConverter();
                            o = c.convert(Integer.class, value.trim());
                        } else {
                            IntegerLocaleConverter c = new IntegerLocaleConverter(Locale.forLanguageTag(this.locale));
                            o = c.convert(value.trim());
                        }
                        break block31;
                    }
                    if (fieldType.equals(Long.TYPE) || fieldType.equals(Long.class)) {
                        if (StringUtils.isEmpty(this.locale)) {
                            LongConverter c = new LongConverter();
                            o = c.convert(Long.class, value.trim());
                        } else {
                            LongLocaleConverter c = new LongLocaleConverter(Locale.forLanguageTag(this.locale));
                            o = c.convert(value.trim());
                        }
                        break block31;
                    }
                    if (fieldType.equals(Short.TYPE) || fieldType.equals(Short.class)) {
                        if (StringUtils.isEmpty(this.locale)) {
                            ShortConverter c = new ShortConverter();
                            o = c.convert(Short.class, value.trim());
                        } else {
                            ShortLocaleConverter c = new ShortLocaleConverter(Locale.forLanguageTag(this.locale));
                            o = c.convert(value.trim());
                        }
                        break block31;
                    }
                    if (fieldType.equals(Character.TYPE) || fieldType.equals(Character.class)) {
                        CharacterConverter c = new CharacterConverter();
                        o = c.convert(Character.class, Character.valueOf(value.charAt(0)));
                        break block31;
                    }
                    if (fieldType.equals(BigDecimal.class)) {
                        if (StringUtils.isEmpty(this.locale)) {
                            BigDecimalConverter c = new BigDecimalConverter();
                            o = c.convert(BigDecimal.class, value.trim());
                        } else {
                            BigDecimalLocaleConverter c = new BigDecimalLocaleConverter(Locale.forLanguageTag(this.locale));
                            o = c.convert(value.trim());
                        }
                        break block31;
                    }
                    if (fieldType.equals(BigInteger.class)) {
                        if (StringUtils.isEmpty(this.locale)) {
                            BigIntegerConverter c = new BigIntegerConverter();
                            o = c.convert(BigInteger.class, value.trim());
                        } else {
                            BigIntegerLocaleConverter c = new BigIntegerLocaleConverter(Locale.forLanguageTag(this.locale));
                            o = c.convert(value.trim());
                        }
                        break block31;
                    }
                    if (fieldType.isAssignableFrom(String.class)) {
                        o = value;
                        break block31;
                    }
                    throw new CsvDataTypeMismatchException(value, fieldType, String.format("Unable to set field value for field '%s' with value '%s' - type is unsupported. Use primitive, boxed primitive, BigDecimal, BigInteger and String types only.", fieldType, value));
                }
                catch (ConversionException e) {
                    CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException((Object)value, fieldType);
                    csve.initCause(e);
                    throw csve;
                }
            }
        }
        return o;
    }
}

