/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.ConversionException;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.converters.DateConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.converters.DateTimeConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.converters.SqlDateConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.converters.SqlTimeConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.converters.SqlTimestampConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.locale.converters.DateLocaleConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.locale.converters.SqlDateLocaleConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.locale.converters.SqlTimeLocaleConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.beanutils.locale.converters.SqlTimestampLocaleConverter;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.lang3.StringUtils;
import com.opencsv.bean.AbstractBeanField;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class BeanFieldDate
extends AbstractBeanField {
    private final boolean required;
    private final String formatString;
    private final String locale;

    public BeanFieldDate(Field field, boolean required, String formatString, String locale) {
        super(field);
        this.required = required;
        this.formatString = formatString;
        this.locale = locale;
    }

    private Object convertCalendar(String value, Class fieldType) throws CsvDataTypeMismatchException {
        java.util.Date d;
        SimpleDateFormat sdf;
        if (StringUtils.isNotEmpty(this.locale)) {
            Locale l = Locale.forLanguageTag(this.locale);
            sdf = new SimpleDateFormat(this.formatString, l);
        } else {
            sdf = new SimpleDateFormat(this.formatString);
        }
        try {
            d = sdf.parse(value);
        }
        catch (ParseException e) {
            CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException((Object)value, fieldType);
            csve.initCause(e);
            throw csve;
        }
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(d);
        Cloneable o = gc;
        if (fieldType == XMLGregorianCalendar.class) {
            try {
                o = DatatypeFactory.newInstance().newXMLGregorianCalendar((GregorianCalendar)o);
            }
            catch (DatatypeConfigurationException e) {
                CsvDataTypeMismatchException ex = new CsvDataTypeMismatchException("It was not possible to initialize an XMLGregorianCalendar.");
                ex.initCause(e);
                throw ex;
            }
        }
        return o;
    }

    private Object convertLocaleSpecific(String value, Class fieldType) throws CsvDataTypeMismatchException {
        Object o;
        DateLocaleConverter c;
        Locale l = Locale.forLanguageTag(this.locale);
        if (fieldType == java.util.Date.class) {
            c = new DateLocaleConverter(l, this.formatString);
        } else if (fieldType == Date.class) {
            c = new SqlDateLocaleConverter(l, this.formatString);
        } else if (fieldType == Time.class) {
            c = new SqlTimeLocaleConverter(l, this.formatString);
        } else if (fieldType == Timestamp.class) {
            c = new SqlTimestampLocaleConverter(l, this.formatString);
        } else {
            throw new CsvDataTypeMismatchException(value, this.field.getType(), "@CsvDate annotation used on non-date field.");
        }
        try {
            o = c.convert(fieldType, (Object)value);
        }
        catch (ConversionException e) {
            CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException((Object)value, fieldType);
            csve.initCause(e);
            throw csve;
        }
        return o;
    }

    private Object convertLocaleInspecific(String value, Class fieldType) throws CsvDataTypeMismatchException {
        Object o;
        DateTimeConverter c;
        Class conversionType = fieldType;
        if (fieldType == java.util.Date.class) {
            c = new DateConverter();
        } else if (fieldType == Date.class) {
            c = new SqlDateConverter();
        } else if (fieldType == Time.class) {
            c = new SqlTimeConverter();
        } else if (fieldType == Timestamp.class) {
            c = new SqlTimestampConverter();
        } else {
            throw new CsvDataTypeMismatchException(value, this.field.getType(), "@CsvDate annotation used on non-date field.");
        }
        c.setPattern(this.formatString);
        try {
            o = c.convert(conversionType, value);
        }
        catch (ConversionException e) {
            CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException((Object)value, fieldType);
            csve.initCause(e);
            throw csve;
        }
        return o;
    }

    @Override
    protected Object convert(String value) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException {
        Object o;
        if (this.required && StringUtils.isEmpty(value)) {
            throw new CsvRequiredFieldEmptyException();
        }
        Class<?> fieldType = this.field.getType();
        List<Class> localeFields = Arrays.asList(java.util.Date.class, Date.class, Time.class, Timestamp.class);
        List<Class> calendarFields = Arrays.asList(Calendar.class, GregorianCalendar.class, XMLGregorianCalendar.class);
        if (localeFields.contains(fieldType)) {
            o = StringUtils.isNotEmpty(this.locale) ? this.convertLocaleSpecific(value, fieldType) : this.convertLocaleInspecific(value, fieldType);
        } else if (calendarFields.contains(fieldType)) {
            o = this.convertCalendar(value, fieldType);
        } else {
            throw new CsvDataTypeMismatchException(value, this.field.getType(), "@CsvDate annotation used on non-date field.");
        }
        return o;
    }
}

