/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.amazonaws.athena.jdbc.shaded.org.apache.commons.lang3.reflect.FieldUtils;
import com.opencsv.bean.BeanField;
import com.opencsv.exceptions.CsvConstraintViolationException;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class AbstractBeanField<T>
implements BeanField<T> {
    protected Field field;

    public AbstractBeanField() {
    }

    public AbstractBeanField(Field field) {
        this.field = field;
    }

    @Override
    public void setField(Field field) {
        this.field = field;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public final <T> void setFieldValue(T bean, String value) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException, CsvConstraintViolationException {
        Object o;
        try {
            o = this.convert(value);
        }
        catch (CsvRequiredFieldEmptyException e) {
            throw new CsvRequiredFieldEmptyException(bean.getClass(), this.field, e.getLocalizedMessage());
        }
        this.assignValueToField(bean, o);
    }

    private <T> void assignValueToField(T bean, Object obj) throws CsvDataTypeMismatchException {
        if (obj != null) {
            Class<?> fieldType = this.field.getType();
            String setterName = "set" + Character.toUpperCase(this.field.getName().charAt(0)) + this.field.getName().substring(1);
            try {
                Method setterMethod = bean.getClass().getMethod(setterName, fieldType);
                try {
                    setterMethod.invoke(bean, obj);
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(obj, fieldType, e.getLocalizedMessage());
                    csve.initCause(e);
                    throw csve;
                }
            }
            catch (NoSuchMethodException e1) {
                try {
                    FieldUtils.writeField(this.field, bean, obj, true);
                }
                catch (IllegalAccessException e2) {
                }
                catch (IllegalArgumentException e2) {
                    CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(obj, fieldType);
                    csve.initCause(e2);
                    throw csve;
                }
            }
            catch (SecurityException e1) {
                try {
                    FieldUtils.writeField(this.field, bean, obj, true);
                }
                catch (IllegalAccessException e2) {
                }
                catch (IllegalArgumentException e2) {
                    CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(obj, fieldType);
                    csve.initCause(e2);
                    throw csve;
                }
            }
        }
    }

    protected abstract Object convert(String var1) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException, CsvConstraintViolationException;
}

