/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.type;

import com.amazonaws.athena.jdbc.shaded.spi.ConnectorSession;
import com.amazonaws.athena.jdbc.shaded.spi.block.Block;
import com.amazonaws.athena.jdbc.shaded.spi.type.AbstractLongType;
import com.amazonaws.athena.jdbc.shaded.spi.type.DateTimeEncoding;
import com.amazonaws.athena.jdbc.shaded.spi.type.SqlTimestampWithTimeZone;
import com.amazonaws.athena.jdbc.shaded.spi.type.TypeSignature;

public final class TimestampWithTimeZoneType
extends AbstractLongType {
    public static final TimestampWithTimeZoneType TIMESTAMP_WITH_TIME_ZONE = new TimestampWithTimeZoneType();

    private TimestampWithTimeZoneType() {
        super(TypeSignature.parseTypeSignature("timestamp with time zone"));
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return new SqlTimestampWithTimeZone(block.getLong(position, 0));
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        long rightValue;
        long leftValue = DateTimeEncoding.unpackMillisUtc(leftBlock.getLong(leftPosition, 0));
        return leftValue == (rightValue = DateTimeEncoding.unpackMillisUtc(rightBlock.getLong(rightPosition, 0)));
    }

    @Override
    public long hash(Block block, int position) {
        return DateTimeEncoding.unpackMillisUtc(block.getLong(position, 0));
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        long leftValue = DateTimeEncoding.unpackMillisUtc(leftBlock.getLong(leftPosition, 0));
        long rightValue = DateTimeEncoding.unpackMillisUtc(rightBlock.getLong(rightPosition, 0));
        return Long.compare(leftValue, rightValue);
    }

    @Override
    public boolean equals(Object other) {
        return other == TIMESTAMP_WITH_TIME_ZONE;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

