/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.type;

import com.amazonaws.athena.jdbc.shaded.jackson.annotation.JsonCreator;
import com.amazonaws.athena.jdbc.shaded.jackson.annotation.JsonValue;
import java.util.Optional;

public enum ParameterKind {
    TYPE(Optional.of("TYPE_SIGNATURE")),
    NAMED_TYPE(Optional.of("NAMED_TYPE_SIGNATURE")),
    LONG(Optional.of("LONG_LITERAL")),
    VARIABLE(Optional.empty());

    private final Optional<String> oldName;

    private ParameterKind(Optional<String> oldName) {
        this.oldName = oldName;
    }

    @JsonValue
    public String jsonName() {
        return this.oldName.orElse(this.name());
    }

    @JsonCreator
    public static ParameterKind fromJsonValue(String value) {
        for (ParameterKind kind : ParameterKind.values()) {
            if (kind.oldName.isPresent() && kind.oldName.get().equals(value)) {
                return kind;
            }
            if (!kind.name().equals(value)) continue;
            return kind;
        }
        throw new IllegalArgumentException("Invalid serialized ParameterKind value: " + value);
    }
}

