/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.type;

import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.Slice;
import com.amazonaws.athena.jdbc.shaded.spi.block.Block;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockBuilder;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockBuilderStatus;
import com.amazonaws.athena.jdbc.shaded.spi.block.IntArrayBlockBuilder;
import com.amazonaws.athena.jdbc.shaded.spi.type.AbstractType;
import com.amazonaws.athena.jdbc.shaded.spi.type.FixedWidthType;
import com.amazonaws.athena.jdbc.shaded.spi.type.TypeSignature;

public abstract class AbstractIntType
extends AbstractType
implements FixedWidthType {
    protected AbstractIntType(TypeSignature signature) {
        super(signature, Long.TYPE);
    }

    @Override
    public final int getFixedSize() {
        return 4;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public final long getLong(Block block, int position) {
        return block.getInt(position, 0);
    }

    @Override
    public final Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, this.getFixedSize());
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        blockBuilder.writeInt((int)value).closeEntry();
    }

    @Override
    public final void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeInt(block.getInt(position, 0)).closeEntry();
        }
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        int rightValue;
        int leftValue = leftBlock.getInt(leftPosition, 0);
        return leftValue == (rightValue = rightBlock.getInt(rightPosition, 0));
    }

    @Override
    public long hash(Block block, int position) {
        return block.getInt(position, 0);
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        int leftValue = leftBlock.getInt(leftPosition, 0);
        int rightValue = rightBlock.getInt(rightPosition, 0);
        return Integer.compare(leftValue, rightValue);
    }

    @Override
    public final BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new IntArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, blockBuilderStatus.getMaxBlockSizeInBytes() / 4));
    }

    @Override
    public final BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 4);
    }

    @Override
    public final BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new IntArrayBlockBuilder(new BlockBuilderStatus(), positionCount);
    }
}

