/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.classloader;

import com.amazonaws.athena.jdbc.shaded.spi.ColumnHandle;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorRecordSetProvider;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorSession;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorSplit;
import com.amazonaws.athena.jdbc.shaded.spi.RecordSet;
import com.amazonaws.athena.jdbc.shaded.spi.classloader.ClassLoaderSafeRecordSet;
import com.amazonaws.athena.jdbc.shaded.spi.classloader.ThreadContextClassLoader;
import java.util.List;
import java.util.Objects;

public class ClassLoaderSafeConnectorRecordSetProvider
implements ConnectorRecordSetProvider {
    private final ConnectorRecordSetProvider delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorRecordSetProvider(ConnectorRecordSetProvider delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public RecordSet getRecordSet(ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ClassLoaderSafeRecordSet classLoaderSafeRecordSet = new ClassLoaderSafeRecordSet(this.delegate.getRecordSet(session, split, columns), this.classLoader);
            return classLoaderSafeRecordSet;
        }
    }

    public String toString() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            String string = this.delegate.toString();
            return string;
        }
    }
}

