/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.block;

import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.Slice;
import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.SliceInput;
import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.SliceOutput;
import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.Slices;
import com.amazonaws.athena.jdbc.shaded.spi.block.AbstractVariableWidthBlock;
import com.amazonaws.athena.jdbc.shaded.spi.block.Block;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncoding;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncodingFactory;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncodingSerde;
import com.amazonaws.athena.jdbc.shaded.spi.block.EncoderUtil;
import com.amazonaws.athena.jdbc.shaded.spi.block.VariableWidthBlock;
import com.amazonaws.athena.jdbc.shaded.spi.type.TypeManager;

public class VariableWidthBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<VariableWidthBlockEncoding> FACTORY = new VariableWidthBlockEncodingFactory();
    private static final String NAME = "VARIABLE_WIDTH";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        AbstractVariableWidthBlock variableWidthBlock = (AbstractVariableWidthBlock)block;
        int positionCount = variableWidthBlock.getPositionCount();
        sliceOutput.appendInt(positionCount);
        int totalLength = 0;
        for (int position = 0; position < positionCount; ++position) {
            int length = variableWidthBlock.getLength(position);
            sliceOutput.appendInt(totalLength += length);
        }
        EncoderUtil.encodeNullsAsBits(sliceOutput, variableWidthBlock);
        sliceOutput.appendInt(totalLength).writeBytes(variableWidthBlock.getRawSlice(0), variableWidthBlock.getPositionOffset(0), totalLength);
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        int[] offsets = new int[positionCount + 1];
        sliceInput.readBytes(Slices.wrappedIntArray((int[])offsets), 4, positionCount * 4);
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount);
        int blockSize = sliceInput.readInt();
        Slice slice = sliceInput.readSlice(blockSize);
        return new VariableWidthBlock(positionCount, slice, offsets, valueIsNull);
    }

    @Override
    public BlockEncodingFactory getFactory() {
        return FACTORY;
    }

    public static class VariableWidthBlockEncodingFactory
    implements BlockEncodingFactory<VariableWidthBlockEncoding> {
        @Override
        public String getName() {
            return VariableWidthBlockEncoding.NAME;
        }

        @Override
        public VariableWidthBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            return new VariableWidthBlockEncoding();
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, VariableWidthBlockEncoding blockEncoding) {
        }
    }
}

