/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.block;

import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.SizeOf;
import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.Slice;
import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.SliceOutput;
import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.Slices;
import com.amazonaws.athena.jdbc.shaded.spi.block.AbstractVariableWidthBlock;
import com.amazonaws.athena.jdbc.shaded.spi.block.Block;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockUtil;
import java.util.Arrays;
import java.util.List;
import org.openjdk.jol.info.ClassLayout;

public class VariableWidthBlock
extends AbstractVariableWidthBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(VariableWidthBlock.class).instanceSize();
    private final int arrayOffset;
    private final int positionCount;
    private final Slice slice;
    private final int[] offsets;
    private final boolean[] valueIsNull;
    private final int retainedSizeInBytes;
    private final int sizeInBytes;

    public VariableWidthBlock(int positionCount, Slice slice, int[] offsets, boolean[] valueIsNull) {
        this(0, positionCount, slice, offsets, valueIsNull);
    }

    VariableWidthBlock(int arrayOffset, int positionCount, Slice slice, int[] offsets, boolean[] valueIsNull) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (slice == null) {
            throw new IllegalArgumentException("slice is null");
        }
        this.slice = slice;
        if (offsets.length - arrayOffset < positionCount + 1) {
            throw new IllegalArgumentException("offsets length is less than positionCount");
        }
        this.offsets = offsets;
        if (valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("valueIsNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.sizeInBytes = BlockUtil.intSaturatedCast((long)(offsets[arrayOffset + positionCount] - offsets[arrayOffset]) + 5L * (long)positionCount);
        this.retainedSizeInBytes = BlockUtil.intSaturatedCast((long)(INSTANCE_SIZE + slice.getRetainedSize()) + SizeOf.sizeOf((boolean[])valueIsNull) + SizeOf.sizeOf((int[])offsets));
    }

    @Override
    protected final int getPositionOffset(int position) {
        return this.offsets[position + this.arrayOffset];
    }

    @Override
    public int getLength(int position) {
        this.checkReadablePosition(position);
        return this.getPositionOffset(position + 1) - this.getPositionOffset(position);
    }

    @Override
    protected boolean isEntryNull(int position) {
        return this.valueIsNull[position + this.arrayOffset];
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public int getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        BlockUtil.checkValidPositions(positions, this.positionCount);
        int finalLength = positions.stream().mapToInt(this::getLength).sum();
        SliceOutput newSlice = Slices.allocate((int)finalLength).getOutput();
        int[] newOffsets = new int[positions.size() + 1];
        boolean[] newValueIsNull = new boolean[positions.size()];
        for (int i = 0; i < positions.size(); ++i) {
            int position = positions.get(i);
            if (this.isEntryNull(position)) {
                newValueIsNull[i] = true;
            } else {
                newSlice.appendBytes(this.slice.getBytes(this.getPositionOffset(position), this.getLength(position)));
            }
            newOffsets[i + 1] = newSlice.size();
        }
        return new VariableWidthBlock(positions.size(), newSlice.slice(), newOffsets, newValueIsNull);
    }

    @Override
    protected Slice getRawSlice(int position) {
        return this.slice;
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new VariableWidthBlock(positionOffset + this.arrayOffset, length, this.slice, this.offsets, this.valueIsNull);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        int[] newOffsets = Arrays.copyOfRange(this.offsets, positionOffset += this.arrayOffset, positionOffset + length + 1);
        int i = 0;
        while (i < newOffsets.length) {
            int n = i++;
            newOffsets[n] = newOffsets[n] - this.offsets[positionOffset];
        }
        Slice newSlice = Slices.copyOf((Slice)this.slice, (int)this.offsets[positionOffset], (int)newOffsets[length]);
        boolean[] newValueIsNull = Arrays.copyOfRange(this.valueIsNull, positionOffset, positionOffset + length);
        return new VariableWidthBlock(length, newSlice, newOffsets, newValueIsNull);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VariableWidthBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append(", slice=").append(this.slice);
        sb.append('}');
        return sb.toString();
    }
}

