/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.block;

import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.SliceInput;
import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.SliceOutput;
import com.amazonaws.athena.jdbc.shaded.spi.block.AbstractInterleavedBlock;
import com.amazonaws.athena.jdbc.shaded.spi.block.Block;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncoding;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncodingFactory;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncodingSerde;
import com.amazonaws.athena.jdbc.shaded.spi.block.InterleavedBlock;
import com.amazonaws.athena.jdbc.shaded.spi.type.TypeManager;

public class InterleavedBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<InterleavedBlockEncoding> FACTORY = new InterleavedBlockEncodingFactory();
    private static final String NAME = "INTERLEAVED";
    private final BlockEncoding[] individualBlockEncodings;

    public InterleavedBlockEncoding(BlockEncoding[] individualBlockEncodings) {
        this.individualBlockEncodings = individualBlockEncodings;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        AbstractInterleavedBlock interleavedBlock = (AbstractInterleavedBlock)block;
        if (interleavedBlock.getBlockCount() != this.individualBlockEncodings.length) {
            throw new IllegalArgumentException("argument block differs in length (" + interleavedBlock.getBlockCount() + ") with this encoding (" + this.individualBlockEncodings.length + ")");
        }
        Block[] subBlocks = interleavedBlock.computeSerializableSubBlocks();
        for (int i = 0; i < subBlocks.length; ++i) {
            this.individualBlockEncodings[i].writeBlock(sliceOutput, subBlocks[i]);
        }
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        Block[] individualBlocks = new Block[this.individualBlockEncodings.length];
        for (int i = 0; i < this.individualBlockEncodings.length; ++i) {
            individualBlocks[i] = this.individualBlockEncodings[i].readBlock(sliceInput);
        }
        return new InterleavedBlock(individualBlocks);
    }

    @Override
    public BlockEncodingFactory getFactory() {
        return FACTORY;
    }

    public static class InterleavedBlockEncodingFactory
    implements BlockEncodingFactory<InterleavedBlockEncoding> {
        @Override
        public String getName() {
            return InterleavedBlockEncoding.NAME;
        }

        @Override
        public InterleavedBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            int individualBlockEncodingsCount = input.readInt();
            BlockEncoding[] individualBlockEncodings = new BlockEncoding[individualBlockEncodingsCount];
            for (int i = 0; i < individualBlockEncodingsCount; ++i) {
                individualBlockEncodings[i] = serde.readBlockEncoding(input);
            }
            return new InterleavedBlockEncoding(individualBlockEncodings);
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, InterleavedBlockEncoding blockEncoding) {
            output.appendInt(blockEncoding.individualBlockEncodings.length);
            for (BlockEncoding individualBlockEncoding : blockEncoding.individualBlockEncodings) {
                serde.writeBlockEncoding(output, individualBlockEncoding);
            }
        }
    }
}

