/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi.block;

import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.SliceInput;
import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.SliceOutput;
import com.amazonaws.athena.jdbc.shaded.io.airlift.slice.Slices;
import com.amazonaws.athena.jdbc.shaded.spi.block.AbstractArrayBlock;
import com.amazonaws.athena.jdbc.shaded.spi.block.ArrayBlock;
import com.amazonaws.athena.jdbc.shaded.spi.block.Block;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncoding;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncodingFactory;
import com.amazonaws.athena.jdbc.shaded.spi.block.BlockEncodingSerde;
import com.amazonaws.athena.jdbc.shaded.spi.block.EncoderUtil;
import com.amazonaws.athena.jdbc.shaded.spi.type.TypeManager;

public class ArrayBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<ArrayBlockEncoding> FACTORY = new ArrayBlockEncodingFactory();
    private static final String NAME = "ARRAY";
    private final BlockEncoding valueBlockEncoding;

    public ArrayBlockEncoding(BlockEncoding valueBlockEncoding) {
        this.valueBlockEncoding = valueBlockEncoding;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        AbstractArrayBlock arrayBlock = (AbstractArrayBlock)block;
        this.valueBlockEncoding.writeBlock(sliceOutput, arrayBlock.getValues());
        sliceOutput.appendInt(arrayBlock.getOffsetBase());
        int positionCount = arrayBlock.getPositionCount();
        sliceOutput.appendInt(positionCount);
        sliceOutput.writeBytes(arrayBlock.getOffsets(), 0, positionCount * 4);
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        Block values = this.valueBlockEncoding.readBlock(sliceInput);
        int offsetBase = sliceInput.readInt();
        int positionCount = sliceInput.readInt();
        byte[] offsets = new byte[positionCount * 4];
        sliceInput.readBytes(offsets);
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount);
        return new ArrayBlock(values, Slices.wrappedBuffer((byte[])offsets), offsetBase, Slices.wrappedBooleanArray((boolean[])valueIsNull));
    }

    @Override
    public BlockEncodingFactory getFactory() {
        return FACTORY;
    }

    public static class ArrayBlockEncodingFactory
    implements BlockEncodingFactory<ArrayBlockEncoding> {
        @Override
        public String getName() {
            return ArrayBlockEncoding.NAME;
        }

        @Override
        public ArrayBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            BlockEncoding valueBlockEncoding = serde.readBlockEncoding(input);
            return new ArrayBlockEncoding(valueBlockEncoding);
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, ArrayBlockEncoding blockEncoding) {
            serde.writeBlockEncoding(output, blockEncoding.valueBlockEncoding);
        }
    }
}

