/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi;

import com.amazonaws.athena.jdbc.shaded.spi.NotFoundException;
import com.amazonaws.athena.jdbc.shaded.spi.SchemaTableName;
import java.util.Objects;

public class ViewNotFoundException
extends NotFoundException {
    private final SchemaTableName viewName;

    public ViewNotFoundException(SchemaTableName viewName) {
        this(viewName, String.format("View '%s' not found", viewName));
    }

    public ViewNotFoundException(SchemaTableName viewName, String message) {
        super(message);
        this.viewName = Objects.requireNonNull(viewName, "viewName is null");
    }

    public ViewNotFoundException(SchemaTableName viewName, Throwable cause) {
        this(viewName, String.format("View '%s' not found", viewName), cause);
    }

    public ViewNotFoundException(SchemaTableName viewName, String message, Throwable cause) {
        super(message, cause);
        this.viewName = Objects.requireNonNull(viewName, "viewName is null");
    }

    public SchemaTableName getViewName() {
        return this.viewName;
    }
}

