/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi;

import com.amazonaws.athena.jdbc.shaded.spi.ColumnHandle;
import com.amazonaws.athena.jdbc.shaded.spi.predicate.TupleDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class DiscretePredicates {
    private final List<ColumnHandle> columns;
    private final List<TupleDomain<ColumnHandle>> predicates;

    public DiscretePredicates(List<ColumnHandle> columns, List<TupleDomain<ColumnHandle>> predicates) {
        Objects.requireNonNull(columns, "columns is null");
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("columns is empty");
        }
        this.columns = Collections.unmodifiableList(new ArrayList<ColumnHandle>(columns));
        this.predicates = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(predicates, "predicates is null")));
    }

    public List<ColumnHandle> getColumns() {
        return this.columns;
    }

    public List<TupleDomain<ColumnHandle>> getPredicates() {
        return this.predicates;
    }
}

