/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc.shaded.spi;

import com.amazonaws.athena.jdbc.shaded.spi.ColumnHandle;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorNodePartitioning;
import com.amazonaws.athena.jdbc.shaded.spi.ConnectorTableLayoutHandle;
import com.amazonaws.athena.jdbc.shaded.spi.DiscretePredicates;
import com.amazonaws.athena.jdbc.shaded.spi.LocalProperty;
import com.amazonaws.athena.jdbc.shaded.spi.predicate.TupleDomain;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ConnectorTableLayout {
    private final ConnectorTableLayoutHandle handle;
    private final Optional<List<ColumnHandle>> columns;
    private final TupleDomain<ColumnHandle> predicate;
    private final Optional<ConnectorNodePartitioning> nodePartitioning;
    private final Optional<Set<ColumnHandle>> streamPartitioningColumns;
    private final Optional<DiscretePredicates> discretePredicates;
    private final List<LocalProperty<ColumnHandle>> localProperties;

    public ConnectorTableLayout(ConnectorTableLayoutHandle handle) {
        this(handle, Optional.empty(), TupleDomain.all(), Optional.empty(), Optional.empty(), Optional.empty(), Collections.emptyList());
    }

    public ConnectorTableLayout(ConnectorTableLayoutHandle handle, Optional<List<ColumnHandle>> columns, TupleDomain<ColumnHandle> predicate, Optional<ConnectorNodePartitioning> nodePartitioning, Optional<Set<ColumnHandle>> streamPartitioningColumns, Optional<DiscretePredicates> discretePredicates, List<LocalProperty<ColumnHandle>> localProperties) {
        Objects.requireNonNull(handle, "handle is null");
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(streamPartitioningColumns, "partitioningColumns is null");
        Objects.requireNonNull(nodePartitioning, "nodePartitioning is null");
        Objects.requireNonNull(predicate, "predicate is null");
        Objects.requireNonNull(discretePredicates, "discretePredicates is null");
        Objects.requireNonNull(localProperties, "localProperties is null");
        this.handle = handle;
        this.columns = columns;
        this.nodePartitioning = nodePartitioning;
        this.streamPartitioningColumns = streamPartitioningColumns;
        this.predicate = predicate;
        this.discretePredicates = discretePredicates;
        this.localProperties = localProperties;
    }

    public ConnectorTableLayoutHandle getHandle() {
        return this.handle;
    }

    public Optional<List<ColumnHandle>> getColumns() {
        return this.columns;
    }

    public TupleDomain<ColumnHandle> getPredicate() {
        return this.predicate;
    }

    public Optional<ConnectorNodePartitioning> getNodePartitioning() {
        return this.nodePartitioning;
    }

    public Optional<Set<ColumnHandle>> getStreamPartitioningColumns() {
        return this.streamPartitioningColumns;
    }

    public Optional<DiscretePredicates> getDiscretePredicates() {
        return this.discretePredicates;
    }

    public List<LocalProperty<ColumnHandle>> getLocalProperties() {
        return this.localProperties;
    }

    public int hashCode() {
        return Objects.hash(this.handle, this.columns, this.predicate, this.discretePredicates, this.streamPartitioningColumns, this.nodePartitioning, this.localProperties);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectorTableLayout other = (ConnectorTableLayout)obj;
        return Objects.equals(this.handle, other.handle) && Objects.equals(this.columns, other.columns) && Objects.equals(this.predicate, other.predicate) && Objects.equals(this.discretePredicates, other.discretePredicates) && Objects.equals(this.streamPartitioningColumns, other.streamPartitioningColumns) && Objects.equals(this.nodePartitioning, other.nodePartitioning) && Objects.equals(this.localProperties, other.localProperties);
    }
}

